/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.tf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.squashtest.tm.core.foundation.lang.MathsUtils;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.testautomation.AutomatedExecutionExtender;
import org.squashtest.tm.domain.testautomation.AutomatedSuite;
import org.squashtest.tm.service.testautomation.model.AutomatedSuiteWithSquashAutomAutomatedITPIs;
import org.squashtest.tm.web.backend.controller.tf.AutomatedExecutionViewUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AutomatedExecutionViewUtils {
    private AutomatedExecutionViewUtils() {
    }

    public static AutomatedSuiteOverview buildExecInfo(AutomatedSuiteWithSquashAutomAutomatedITPIs suite) {
        List executions = suite.getSuite().getExecutionExtenders();
        Collection filteredExecutions = executions.stream().filter(exec -> exec.getAutomatedTest() != null).collect(Collectors.toList());
        List items = suite.getSquashAutomAutomatedItems();
        ArrayList<ExecutionAutoView> executionsViews = new ArrayList<ExecutionAutoView>(filteredExecutions.size());
        ArrayList<ItemAutoView> itemsViews = new ArrayList<ItemAutoView>(items.size());
        int totalExec = filteredExecutions.size();
        int totalTerminated = 0;
        for (AutomatedExecutionExtender autoExec : filteredExecutions) {
            Execution execution = autoExec.getExecution();
            if (execution.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            ExecutionAutoView execView = AutomatedExecutionViewUtils.convertAutoExecToExecOverview((AutomatedExecutionExtender)autoExec);
            executionsViews.add(execView);
        }
        for (IterationTestPlanItem item : items) {
            ItemAutoView itemView = AutomatedExecutionViewUtils.translateItemInView((IterationTestPlanItem)item);
            itemsViews.add(itemView);
        }
        int percentage = AutomatedExecutionViewUtils.percentProgression((int)totalTerminated, (int)totalExec);
        return new AutomatedSuiteOverview(percentage, suite.getSuite().getId(), executionsViews, itemsViews);
    }

    public static AutomatedSuiteOverview buildExecInfo(AutomatedSuite suite) {
        List executions = suite.getExecutionExtenders();
        Collection filteredExecutions = executions.stream().filter(exec -> exec.getAutomatedTest() != null).collect(Collectors.toList());
        ArrayList<ExecutionAutoView> executionsViews = new ArrayList<ExecutionAutoView>(filteredExecutions.size());
        int totalExec = filteredExecutions.size();
        int totalTerminated = 0;
        for (AutomatedExecutionExtender autoExec : filteredExecutions) {
            Execution execution = autoExec.getExecution();
            if (execution.getExecutionStatus().isTerminatedStatus()) {
                ++totalTerminated;
            }
            ExecutionAutoView execView = AutomatedExecutionViewUtils.convertAutoExecToExecOverview((AutomatedExecutionExtender)autoExec);
            executionsViews.add(execView);
        }
        int percentage = AutomatedExecutionViewUtils.percentProgression((int)totalTerminated, (int)totalExec);
        return new AutomatedSuiteOverview(percentage, suite.getId(), executionsViews);
    }

    private static int percentProgression(int totalTerminated, int totalExec) {
        if (totalExec == 0) {
            return 100;
        }
        return MathsUtils.percent((long)totalTerminated, (long)totalExec);
    }

    public static ExecutionAutoView convertAutoExecToExecOverview(AutomatedExecutionExtender autoExec) {
        ExecutionAutoView execView = new ExecutionAutoView(autoExec.getExecution().getId(), autoExec.getExecution().getName(), autoExec.getExecution().getExecutionStatus(), autoExec.getNodeName(), autoExec.getAutomatedProject().getLabel());
        return execView;
    }

    public static ItemAutoView translateItemInView(IterationTestPlanItem autoItem) {
        ItemAutoView itemAutoView = new ItemAutoView();
        itemAutoView.id = autoItem.getId();
        itemAutoView.name = autoItem.getReferencedTestCase().getName();
        itemAutoView.automatedServerName = autoItem.getReferencedTestCase().getProject().getTestAutomationServer().getName();
        return itemAutoView;
    }
}

