/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.project;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.web.backend.controller.test.automation.project.TestAutomationProjectController;
import org.squashtest.tm.web.backend.model.testautomation.TAUsageStatus;

@Controller
@RequestMapping(value={"/backend/test-automation-projects"})
public class TestAutomationProjectController {
    @Inject
    private TestAutomationProjectManagerService service;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationProjectController.class);
    private static final String PROJECT_ID = "/{projectId}";
    private static final String PROJECT_IDS = "/{projectIds}";

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteTestAutomationProject(@PathVariable long projectId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete test automation project of id #{}", (Object)projectId);
        }
        this.service.deleteProject(projectId);
    }

    @RequestMapping(value={"/{projectId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, List<TestAutomationProjectDto>> editTestAutomationProject(@PathVariable long projectId, @RequestBody Patch patch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Edit test automation project of id #{}", (Object)projectId);
        }
        try {
            TestAutomationProject testAutomationProject = new TestAutomationProject();
            testAutomationProject.setCanRunGherkin(patch.isCanRunBdd());
            testAutomationProject.setJobName(patch.getRemoteName());
            testAutomationProject.setLabel(patch.getLabel());
            testAutomationProject.setSlaves(patch.getExecutionEnvironment());
            this.service.editProject(projectId, testAutomationProject);
            Long tmProjectId = this.service.findProjectById(projectId).getTmProject().getId();
            return Collections.singletonMap("taProjects", this.service.findAllByTMProject(tmProjectId.longValue()));
        }
        catch (DomainException de) {
            de.setObjectName("ta-project");
            throw de;
        }
    }

    @RequestMapping(value={"/{projectIds}/usage-status"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, TAUsageStatus> getTestAutomationUsageStatus(@PathVariable List<Long> projectIds) {
        boolean hasExecutedTests = projectIds.stream().anyMatch(id -> this.service.hasExecutedTests(id.longValue()));
        return Collections.singletonMap("usageStatus", new TAUsageStatus(hasExecutedTests));
    }

    @PostMapping(value={"/{projectId}/label"})
    @ResponseBody
    public Map<String, List<TestAutomationProjectDto>> changeLabel(@PathVariable long projectId, @RequestBody Patch patch) {
        if (patch.getLabel() == null || patch.getLabel().trim().isEmpty()) {
            throw new RequiredFieldException("label");
        }
        try {
            this.service.changeLabel(projectId, patch.getLabel().trim());
            Long tmProjectId = this.service.findProjectById(projectId).getTmProject().getId();
            return Collections.singletonMap("taProjects", this.service.findAllByTMProject(tmProjectId.longValue()));
        }
        catch (DomainException de) {
            de.setObjectName("ta-project");
            throw de;
        }
    }

    @PostMapping(value={"/{projectId}/can-run-bdd"})
    @ResponseBody
    public Map<String, List<TestAutomationProjectDto>> changeCanRunBdd(@PathVariable long projectId, @RequestBody Patch patch) {
        try {
            this.service.changeCanRunGherkin(projectId, patch.isCanRunBdd());
            Long tmProjectId = this.service.findProjectById(projectId).getTmProject().getId();
            return Collections.singletonMap("taProjects", this.service.findAllByTMProject(tmProjectId.longValue()));
        }
        catch (DomainException de) {
            de.setObjectName("ta-project");
            throw de;
        }
    }
}

