/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.display.search.TestCaseSearchGridDisplayService;
import org.squashtest.tm.service.display.search.TestCaseSearchInputData;
import org.squashtest.tm.service.display.search.TestCaseSearchInputDataProvider;
import org.squashtest.tm.service.display.search.TestCaseSearchService;
import org.squashtest.tm.service.display.search.TestCaseThroughRequirementSearchService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"backend/search/test-case"})
public class TestCaseSearchController {
    private final TestCaseSearchService testCaseSearchService;
    private final TestCaseSearchGridDisplayService testCaseResearchGridService;
    private final TestCaseSearchInputDataProvider inputDataProvider;
    private final TestCaseThroughRequirementSearchService testCaseThroughRequirementSearchService;

    public TestCaseSearchController(TestCaseSearchService testCaseSearchService, TestCaseSearchGridDisplayService testCaseResearchGridService, TestCaseSearchInputDataProvider inputDataProvider, TestCaseThroughRequirementSearchService testCaseThroughRequirementSearchService) {
        this.testCaseSearchService = testCaseSearchService;
        this.testCaseResearchGridService = testCaseResearchGridService;
        this.inputDataProvider = inputDataProvider;
        this.testCaseThroughRequirementSearchService = testCaseThroughRequirementSearchService;
    }

    @GetMapping
    public TestCaseSearchInputData getTestCaseResearchInputData() {
        return this.inputDataProvider.provideTestCaseResearchInputData();
    }

    @PostMapping
    public GridResponse searchTestCase(@RequestBody GridRequest gridRequest) {
        ResearchResult result = this.testCaseSearchService.search(gridRequest);
        return this.testCaseResearchGridService.fetchResearchRows(result);
    }

    @PostMapping(value={"/by-requirement"})
    public GridResponse searchTestCaseByRequirement(@RequestBody GridRequest gridRequest) {
        ResearchResult tcResult = this.testCaseThroughRequirementSearchService.search(gridRequest);
        return this.testCaseResearchGridService.fetchResearchRows(tcResult);
    }
}

