/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.search.RequirementSearchGridDisplayService;
import org.squashtest.tm.service.display.search.RequirementSearchInputData;
import org.squashtest.tm.service.display.search.RequirementSearchInputDataProvider;
import org.squashtest.tm.service.display.search.RequirementSearchService;
import org.squashtest.tm.service.display.search.ResearchResult;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;

@RestController
@RequestMapping(value={"backend/search/requirement"})
public class RequirementSearchController {
    private final RequirementSearchInputDataProvider inputDataProvider;
    private final RequirementSearchService requirementSearchService;
    private final RequirementSearchGridDisplayService requirementSearchGridService;

    public RequirementSearchController(RequirementSearchInputDataProvider inputDataProvider, RequirementSearchService requirementSearchService, RequirementSearchGridDisplayService requirementSearchGridService) {
        this.inputDataProvider = inputDataProvider;
        this.requirementSearchService = requirementSearchService;
        this.requirementSearchGridService = requirementSearchGridService;
    }

    @GetMapping
    public RequirementSearchInputData getSearchInputData() {
        return this.inputDataProvider.provide();
    }

    @PostMapping
    public GridResponse search(@RequestBody GridRequest gridRequest) {
        ResearchResult result = this.requirementSearchService.search(gridRequest);
        return this.requirementSearchGridService.fetchResearchRows(result);
    }
}

