/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.report;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.web.backend.helper.JsonHelper;
import org.squashtest.tm.web.backend.report.IdentifiedReportDecorator;
import org.squashtest.tm.web.backend.report.ReportsRegistry;
import org.squashtest.tm.web.backend.report.criteria.ConciseFormToCriteriaConverter;

@Controller
@RequestMapping(value={"backend/reports/{namespace}"})
public class ReportGenerationController {
    private final ReportsRegistry reportsRegistry;
    private final ProjectFinder projectFinder;

    public ReportGenerationController(ReportsRegistry reportsRegistry, ProjectFinder projectFinder) {
        this.reportsRegistry = reportsRegistry;
        this.projectFinder = projectFinder;
    }

    @RequestMapping(value={"/views/{viewIndex}/formats/{format}"}, method={RequestMethod.GET}, params={"json"})
    public ModelAndView getReportView(@PathVariable String namespace, @PathVariable int viewIndex, @PathVariable String format, @RequestParam(value="json") String parameters) throws IOException {
        Map form = JsonHelper.deserialize((String)parameters);
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(namespace);
        List projects = this.projectFinder.findAllOrderedByName();
        Map crit = new ConciseFormToCriteriaConverter((Report)report, projects).convert(form);
        return report.buildModelAndView(viewIndex, format, crit);
    }

    @RequestMapping(value={"/views/{viewIndex}/data/docx"}, method={RequestMethod.GET}, params={"json"})
    @ResponseBody
    public Map<String, Object> getReportView(@PathVariable String namespace, @PathVariable int viewIndex, @RequestParam(value="json") String parameters) throws IOException {
        Map form = JsonHelper.deserialize((String)parameters);
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(namespace);
        List projects = this.projectFinder.findAllOrderedByName();
        Map crit = new ConciseFormToCriteriaConverter((Report)report, projects).convert(form);
        return report.buildModelAndView(viewIndex, "docx", crit).getModel();
    }

    @RequestMapping(value={"/views/{viewIndex}/docxtemplate"}, method={RequestMethod.GET})
    public void getTemplate(@PathVariable String namespace, @PathVariable int viewIndex, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IdentifiedReportDecorator report = this.reportsRegistry.findReport(namespace);
        report.getViews()[viewIndex].getSpringView().render(null, request, response);
    }
}

