/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.infolist;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.infolist.UserListItem;
import org.squashtest.tm.service.display.infolist.InfoListDisplayService;
import org.squashtest.tm.service.infolist.InfoListItemManagerService;
import org.squashtest.tm.service.infolist.InfoListManagerService;
import org.squashtest.tm.service.internal.display.dto.InfoListAdminViewDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.form.model.InfoListFormModel;
import org.squashtest.tm.web.backend.controller.infolist.InfoListController;

@Controller
@RequestMapping(value={"/backend/info-lists"})
public class InfoListController {
    InfoListDisplayService infoListDisplayService;
    InfoListManagerService infoListManagerService;
    InfoListItemManagerService infoListItemManagerService;

    @Inject
    InfoListController(InfoListDisplayService infoListDisplayService, InfoListManagerService infoListManagerService, InfoListItemManagerService infoListItemManagerService) {
        this.infoListDisplayService = infoListDisplayService;
        this.infoListManagerService = infoListManagerService;
        this.infoListItemManagerService = infoListItemManagerService;
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllUserInfoLists(@RequestBody GridRequest request) {
        return this.infoListDisplayService.findAll(request);
    }

    @ResponseBody
    @RequestMapping(value={"/{listIds}"}, method={RequestMethod.DELETE})
    public void deleteInfoLists(@PathVariable List<Long> listIds) {
        this.infoListManagerService.remove(listIds);
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Map<String, Object> createInfoList(@RequestBody InfoListFormModel infoListFormModel) {
        InfoList infoList = infoListFormModel.getInfoList();
        this.infoListManagerService.persist(infoList);
        return Collections.singletonMap("id", infoList.getId());
    }

    @ResponseBody
    @RequestMapping(value={"/{infoListId}/label"}, method={RequestMethod.POST})
    public void changeLabel(@PathVariable long infoListId, @RequestBody InfoListPatch patch) {
        this.infoListManagerService.changeLabel(infoListId, patch.getLabel());
    }

    @ResponseBody
    @RequestMapping(value={"/{infoListId}/description"}, method={RequestMethod.POST})
    public void changeDescription(@PathVariable long infoListId, @RequestBody InfoListPatch patch) {
        this.infoListManagerService.changeDescription(infoListId, patch.getDescription());
    }

    @ResponseBody
    @RequestMapping(value={"/{infoListId}/code"}, method={RequestMethod.POST})
    public void changeCode(@PathVariable long infoListId, @RequestBody InfoListPatch patch) {
        this.infoListManagerService.changeCode(infoListId, patch.getCode());
    }

    @ResponseBody
    @RequestMapping(value={"/{infoListId}/items/new"}, method={RequestMethod.POST})
    public InfoListAdminViewDto addItem(@PathVariable long infoListId, @RequestBody NewInfoListItem newItem) {
        this.infoListItemManagerService.checkCodePattern(newItem.getCode());
        this.infoListItemManagerService.checkIfCodeAlreadyExists(newItem.getCode());
        UserListItem item = new UserListItem();
        item.setCode(newItem.getCode());
        item.setLabel(newItem.getLabel());
        item.setColour(newItem.getColour());
        item.setIconName(newItem.getIconName());
        this.infoListItemManagerService.addInfoListItem(infoListId, (InfoListItem)item);
        return this.infoListDisplayService.getInfoListView(infoListId);
    }

    @RequestMapping(value={"/check-if-item-code-already-exists/{code}"}, method={RequestMethod.GET})
    @ResponseBody
    public void checkIfItemCodeAlreadyExists(@PathVariable String code) {
        this.infoListItemManagerService.checkIfCodeAlreadyExists(code);
    }
}

