/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customfield;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;
import org.squashtest.tm.service.display.custom.field.CustomFieldDisplayService;
import org.squashtest.tm.service.internal.display.dto.CustomFieldDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.web.backend.controller.customfield.CustomFieldsController;
import org.squashtest.tm.web.backend.controller.form.model.CustomFieldFormModel;

@Controller
@RequestMapping(value={"/backend/custom-fields"})
public class CustomFieldsController {
    private static final String CUSTOM_FIELDS_URL = "/{customFieldIds}";
    CustomFieldDisplayService customFieldDisplayService;
    CustomFieldManagerService customFieldManagerService;

    public CustomFieldsController(CustomFieldDisplayService customFieldDisplayService, CustomFieldManagerService customFieldManagerService) {
        this.customFieldDisplayService = customFieldDisplayService;
        this.customFieldManagerService = customFieldManagerService;
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllCustomFields(@RequestBody GridRequest request) {
        return this.customFieldDisplayService.findAll(request);
    }

    @ResponseBody
    @GetMapping
    public Map<String, List<CustomFieldDto>> getAllNamedReferences() {
        return Collections.singletonMap("customFields", this.customFieldDisplayService.findAllWithPossibleValues());
    }

    @RequestMapping(value={"/new"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    public Map<String, Object> createCustomField(@RequestBody CustomFieldFormModel customFieldFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        CustomField customField = customFieldFormModel.getCustomField();
        this.customFieldManagerService.persist(customField);
        response.put("id", customField.getId());
        return response;
    }

    @RequestMapping(value={"/{cufId}/label"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeLabel(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeLabel(cufId, patch.getLabel());
    }

    @RequestMapping(value={"/{cufId}/name"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeName(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeName(cufId, patch.getName());
    }

    @RequestMapping(value={"/{cufId}/code"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeCode(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeCode(cufId, patch.getCode());
    }

    @RequestMapping(value={"/{cufId}/optional"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeOptional(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeOptional(Long.valueOf(cufId), Boolean.valueOf(patch.isOptional()));
    }

    @RequestMapping(value={"/{cufId}/default-value"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeDefaultValue(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeDefaultValue(cufId, patch.getDefaultValue());
    }

    @RequestMapping(value={"/{cufId}/numeric-default-value"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeNumericDefaultValue(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        Double value = patch.getNumericDefaultValue();
        this.customFieldManagerService.changeDefaultValue(cufId, value == null ? null : value.toString());
    }

    @RequestMapping(value={"/{cufId}/large-default-value"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeLargeDefaultValue(@PathVariable long cufId, @RequestBody CustomFieldPatch patch) {
        this.customFieldManagerService.changeDefaultValue(cufId, patch.getLargeDefaultValue());
    }

    @ResponseBody
    @RequestMapping(value={"/{customFieldIds}"}, method={RequestMethod.DELETE})
    public void deleteCustomField(@PathVariable(value="customFieldIds") List<Long> customFieldIds) {
        this.customFieldManagerService.deleteCustomField(customFieldIds);
    }

    @RequestMapping(value={"/{cufId}/options/new"}, method={RequestMethod.POST})
    @ResponseBody
    public CustomFieldDto addOption(@PathVariable long cufId, @Valid @RequestBody CustomFieldOption option) {
        try {
            this.customFieldManagerService.addOption(Long.valueOf(cufId), option);
        }
        catch (DomainException e) {
            e.setObjectName("new-cuf-option");
            throw e;
        }
        return this.customFieldDisplayService.getCustomFieldView(Long.valueOf(cufId));
    }

    @RequestMapping(value={"/{cufId}/options/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public void removeOption(@PathVariable long cufId, @RequestBody Map<String, List<String>> request) {
        this.customFieldManagerService.removeOptions(cufId, request.get("optionLabels"));
    }

    @RequestMapping(value={"/{cufId}/options/label"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeOptionLabel(@PathVariable long cufId, @RequestBody CustomFieldOptionPatch patch) {
        if (patch.getNewLabel() == null || patch.getNewLabel().trim().isEmpty()) {
            throw new RequiredFieldException("label");
        }
        try {
            this.customFieldManagerService.changeOptionLabel(Long.valueOf(cufId), patch.getCurrentLabel(), patch.getNewLabel());
        }
        catch (DomainException e) {
            e.setObjectName("rename-cuf-option");
            throw e;
        }
    }

    @RequestMapping(value={"/{cufId}/options/code"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeOptionCode(@PathVariable long cufId, @RequestBody CustomFieldOptionPatch patch) {
        if (patch.getCode() == null || patch.getCode().trim().isEmpty()) {
            throw new RequiredFieldException("code");
        }
        try {
            this.customFieldManagerService.changeOptionCode(cufId, patch.getCurrentLabel(), patch.getCode());
        }
        catch (DomainException e) {
            e.setObjectName("change-cuf-option-code");
            throw e;
        }
    }

    @RequestMapping(value={"/{cufId}/options/color"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeOptionColor(@PathVariable long cufId, @RequestBody CustomFieldOptionPatch patch) {
        try {
            this.customFieldManagerService.changeOptionColour(cufId, patch.getCurrentLabel(), patch.getColor());
        }
        catch (DomainException e) {
            e.setObjectName("change-cuf-option-colour");
            throw e;
        }
    }

    @RequestMapping(value={"/{cufId}/options/positions"}, method={RequestMethod.POST})
    @ResponseBody
    public CustomFieldDto changeOptionsPositions(@PathVariable long cufId, @RequestBody ReorderOptionsRequestBody requestBody) {
        this.customFieldManagerService.changeOptionsPositions(cufId, requestBody.position.intValue(), requestBody.getLabels());
        return this.customFieldDisplayService.getCustomFieldView(Long.valueOf(cufId));
    }
}

