/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.filter.xss;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Whitelist;
import org.owasp.encoder.esapi.ESAPIEncoder;
import org.owasp.esapi.errors.IntrusionException;

public class XSSRequestWrapper
extends HttpServletRequestWrapper {
    private final String HEADER_REFERER = "referer";

    public XSSRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public Map<String, String[]> getParameterMap() {
        Map parameterMap = super.getParameterMap();
        if (Objects.isNull(parameterMap)) {
            return null;
        }
        parameterMap.forEach(this::stripXSS);
        return parameterMap;
    }

    public String[] getParameterValues(String name) {
        String[] parameterValues = super.getParameterValues(name);
        if (Objects.isNull(parameterValues)) {
            return null;
        }
        this.stripXSS(name, parameterValues);
        return parameterValues;
    }

    public String getParameter(String name) {
        String parameterValue = super.getParameter(name);
        this.stripXSS(name, parameterValue);
        return parameterValue;
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration headers = super.getHeaders(name);
        while (headers.hasMoreElements()) {
            String[] tokens;
            String header = (String)headers.nextElement();
            String[] stringArray = tokens = header.split(",");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                this.stripXSS(name, token);
                ++n2;
            }
        }
        return super.getHeaders(name);
    }

    public String getHeader(String name) {
        String header = super.getHeader(name);
        this.stripXSS(name, header);
        return header;
    }

    private void stripXSS(String parameterName, String[] values) {
        Arrays.stream(values).forEach(value -> this.stripXSS(parameterName, (String)value));
    }

    private void stripXSS(String parameterName, String value) {
        if (parameterName.equals("referer")) {
            this.doStripXSS(value, StripOptions.ALLOW_MIXED_ENCODING);
        } else {
            this.doStripXSS(value, StripOptions.STRICT);
        }
    }

    private void doStripXSS(String value, StripOptions options) {
        if (value != null) {
            String escapedValue = ESAPIEncoder.getInstance().canonicalize(value, options.restrictMultiple, options.restrictMixed).replaceAll("\u0000", "").trim();
            Document.OutputSettings outputSettings = new Document.OutputSettings();
            outputSettings.escapeMode(Entities.EscapeMode.xhtml);
            boolean cleanedValue = Jsoup.isValid((String)escapedValue, (Whitelist)Whitelist.none());
            if (!cleanedValue) {
                String message = String.format("Xss protection activated. Escaped value %s. Raw value was %s", escapedValue, value);
                throw new IntrusionException("", message);
            }
        }
    }

    private static enum StripOptions {
        STRICT(true, true),
        ALLOW_MIXED_ENCODING(true, false);

        final boolean restrictMultiple;
        final boolean restrictMixed;

        private StripOptions(boolean restrictMultiple, boolean restrictMixed) {
            this.restrictMultiple = restrictMultiple;
            this.restrictMixed = restrictMixed;
        }
    }
}

