/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseLibraryDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/test-case-library-view"})
public class TestCaseLibraryViewController {
    private TestCaseDisplayService testCaseDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public TestCaseLibraryViewController(TestCaseDisplayService testCaseDisplayService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, TestCaseLibraryNavigationService testCaseLibraryNavigationService) {
        this.testCaseDisplayService = testCaseDisplayService;
        this.builderProvider = builderProvider;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
    }

    @RequestMapping(value={"/{testCaseLibraryId}"}, method={RequestMethod.GET})
    public TestCaseLibraryDto getTestCaseView(@PathVariable long testCaseLibraryId, Locale locale) {
        TestCaseLibraryDto dto = this.testCaseDisplayService.getTestCaseLibraryView(testCaseLibraryId);
        if (dto.isShouldShowFavoriteDashboard()) {
            if (dto.isCanShowFavoriteDashboard()) {
                EntityReference library = new EntityReference(EntityType.TEST_CASE_LIBRARY, Long.valueOf(testCaseLibraryId));
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, Collections.singletonList(library), false, Workspace.TEST_CASE);
                dto.setDashboard(jsonDashboard);
            }
        } else {
            dto.setStatistics(this.testCaseLibraryNavigationService.getStatisticsForSelection((Collection)Lists.newArrayList((Object[])new Long[]{testCaseLibraryId}), Collections.emptyList()));
        }
        return dto;
    }
}

