/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.milestone;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.milestone.MilestoneLabelAlreadyExistsException;
import org.squashtest.tm.exception.milestone.MilestoneRangeNotFoundException;
import org.squashtest.tm.exception.milestone.MilestoneWritePermissionDenied;
import org.squashtest.tm.service.display.milestone.MilestoneDisplayService;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.user.UserAdministrationService;
import org.squashtest.tm.web.backend.controller.form.model.MilestoneFormModel;

@Controller
@RequestMapping(value={"/backend/milestones"})
public class MilestoneController {
    private static final String MILESTONES_URL = "/{milestoneIds}";
    private final MilestoneDisplayService milestoneDisplayService;
    private final MilestoneManagerService milestoneManager;
    private final PermissionEvaluationService permissionEvaluationService;
    private final ProjectFinder projectFinder;
    private final UserAdministrationService userAdministrationService;
    private final UserAccountService userService;
    private final MilestoneBindingManagerService milestoneBindingManager;

    @Inject
    MilestoneController(MilestoneDisplayService milestoneDisplayService, MilestoneManagerService milestoneManager, PermissionEvaluationService permissionEvaluationService, ProjectFinder projectFinder, UserAdministrationService userAdministrationService, UserAccountService userService, MilestoneBindingManagerService milestoneBindingManager) {
        this.milestoneDisplayService = milestoneDisplayService;
        this.milestoneManager = milestoneManager;
        this.permissionEvaluationService = permissionEvaluationService;
        this.projectFinder = projectFinder;
        this.userAdministrationService = userAdministrationService;
        this.userService = userService;
        this.milestoneBindingManager = milestoneBindingManager;
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllMilestones(@RequestBody GridRequest request) {
        return this.milestoneDisplayService.findAll(request);
    }

    @ResponseBody
    @RequestMapping(value={"/{milestoneIds}"}, method={RequestMethod.DELETE})
    public void deleteMilestone(@PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.milestoneManager.removeMilestones(milestoneIds);
    }

    @ResponseBody
    @PostMapping(value={"/new"})
    public Map<String, Object> addMilestone(@Valid @RequestBody MilestoneFormModel milestoneFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Milestone milestone = milestoneFormModel.getMilestone();
        this.setRange(milestone);
        this.setPerimeter(milestone);
        try {
            this.milestoneManager.addMilestone(milestone);
            response.put("id", milestone.getId());
        }
        catch (MilestoneLabelAlreadyExistsException milestoneLabelAlreadyExistsException) {
            throw new NameAlreadyInUseException("Milestone", milestoneFormModel.getLabel(), "label");
        }
        return response;
    }

    private void setRange(Milestone milestone) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(MilestoneRange.GLOBAL);
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
    }

    private void setPerimeter(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            List projects = this.projectFinder.findAllICanManage();
            milestone.addProjectsToPerimeter(projects);
        }
    }

    @RequestMapping(value={"/{milestoneId}/label"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeLabel(@PathVariable long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        try {
            this.milestoneManager.changeLabel(milestoneId, patch.getLabel());
        }
        catch (MilestoneLabelAlreadyExistsException milestoneLabelAlreadyExistsException) {
            throw new NameAlreadyInUseException("Milestone", patch.getLabel(), "label");
        }
    }

    @ResponseBody
    @PostMapping(value={"/{milestoneId}/status"})
    public MilestoneDto changeStatus(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        MilestoneStatus status = MilestoneStatus.valueOf((String)patch.getStatus());
        this.milestoneManager.changeStatus(milestoneId.longValue(), status);
        if (status.equals((Object)MilestoneStatus.PLANNED)) {
            this.milestoneManager.unbindAllObjects(milestoneId.longValue());
        }
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"/{milestoneId}/end-date"})
    public MilestoneDto changeEndDate(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeEndDate(milestoneId.longValue(), patch.getEndDate());
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"/{milestoneId}/range"})
    public MilestoneDto changeRange(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.milestoneManager.verifyCanEditMilestoneRange();
        this.checkRangeParameter(patch.getRange());
        if (patch.getRange().equals("RESTRICTED") && this.milestoneManager.isBoundToATemplate(milestoneId)) {
            this.milestoneBindingManager.unbindTemplateFrom(milestoneId);
        }
        this.milestoneManager.changeOwner(milestoneId.longValue(), this.userService.findCurrentUser());
        this.milestoneManager.changeRange(milestoneId.longValue(), MilestoneRange.valueOf((String)patch.getRange()));
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    private void checkRangeParameter(String range) {
        try {
            MilestoneRange.valueOf((String)range);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MilestoneRangeNotFoundException();
        }
    }

    @ResponseBody
    @PostMapping(value={"/{milestoneId}/description"})
    public MilestoneDto changeDescription(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        this.milestoneManager.changeDescription(milestoneId.longValue(), patch.getDescription());
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @ResponseBody
    @PostMapping(value={"/{milestoneId}/owner"})
    public MilestoneDto changeOwner(@PathVariable(value="milestoneId") Long milestoneId, @RequestBody MilestonePatch patch) {
        this.verifyCanEditMilestone(milestoneId);
        User newOwner = this.userAdministrationService.findByLogin(patch.getOwnerLogin());
        this.milestoneManager.changeOwner(milestoneId.longValue(), newOwner);
        return this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
    }

    @ResponseBody
    @GetMapping(value={"possible-owners"})
    public Map<String, List<User>> findPossibleOwners() {
        List sortedUsers = this.userAdministrationService.findAllAdminOrManager().stream().sorted((o1, o2) -> o1.getLogin().compareToIgnoreCase(o2.getLogin())).collect(Collectors.toList());
        return Collections.singletonMap("users", sortedUsers);
    }

    @ResponseBody
    @RequestMapping(value={"/{motherId}/clone"}, method={RequestMethod.POST})
    public Map<String, Long> cloneMilestone(@PathVariable(value="motherId") long motherId, @RequestBody MilestoneDuplicationPatch patch) {
        Milestone milestone = new Milestone();
        milestone.setLabel(patch.getLabel());
        milestone.setStatus(patch.getStatus());
        milestone.setEndDate(patch.getEndDate());
        milestone.setDescription(patch.getDescription());
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(this.milestoneManager.findById(motherId).getRange());
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
        try {
            this.milestoneManager.cloneMilestone(motherId, milestone, patch.isBindToRequirements(), patch.isBindToTestCases());
            return Collections.singletonMap("id", milestone.getId());
        }
        catch (MilestoneLabelAlreadyExistsException milestoneLabelAlreadyExistsException) {
            throw new NameAlreadyInUseException("Milestone", patch.getLabel(), "label");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{sourceId}/synchronize/{targetId}"}, method={RequestMethod.POST})
    public void synchronizeMilestone(@PathVariable(value="sourceId") long sourceId, @PathVariable(value="targetId") long targetId, @RequestBody SynchronizationParameters parameters) {
        this.milestoneManager.synchronize(sourceId, targetId, parameters.isExtendPerimeter(), parameters.isUnion());
    }

    private void verifyCanEditMilestone(Long milestoneId) {
        try {
            this.milestoneManager.verifyCanEditMilestone(milestoneId.longValue());
        }
        catch (IllegalAccessError illegalAccessError) {
            throw new MilestoneWritePermissionDenied();
        }
    }

    public static class MilestoneDuplicationPatch {
        private String label;
        private MilestoneStatus status;
        private Date endDate;
        private String description;
        private boolean bindToRequirements;
        private boolean bindToTestCases;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public MilestoneStatus getStatus() {
            return this.status;
        }

        public void setStatus(MilestoneStatus status) {
            this.status = status;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isBindToRequirements() {
            return this.bindToRequirements;
        }

        public void setBindToRequirements(boolean bindToRequirements) {
            this.bindToRequirements = bindToRequirements;
        }

        public boolean isBindToTestCases() {
            return this.bindToTestCases;
        }

        public void setBindToTestCases(boolean bindToTestCases) {
            this.bindToTestCases = bindToTestCases;
        }
    }

    public static class MilestonePatch {
        private String label;
        private String range;
        private Date endDate;
        private String status;
        private String description;
        private String ownerLogin;

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getRange() {
            return this.range;
        }

        public void setRange(String range) {
            this.range = range;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getOwnerLogin() {
            return this.ownerLogin;
        }

        public void setOwnerLogin(String ownerLogin) {
            this.ownerLogin = ownerLogin;
        }
    }

    public static class SynchronizationParameters {
        boolean extendPerimeter;
        boolean union;

        public boolean isExtendPerimeter() {
            return this.extendPerimeter;
        }

        public void setExtendPerimeter(boolean extendPerimeter) {
            this.extendPerimeter = extendPerimeter;
        }

        public boolean isUnion() {
            return this.union;
        }

        public void setUnion(boolean isUnion) {
            this.union = isUnion;
        }
    }
}

