/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.dto.json.JsonChartInstance;

@RestController
@RequestMapping(value={"/backend/chart-definition-view"})
public class ChartDefinitionViewController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final ChartModificationService chartService;

    public ChartDefinitionViewController(CustomReportLibraryNodeService customReportLibraryNodeService, ChartModificationService chartService) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.chartService = chartService;
    }

    @RequestMapping(value={"/{customReportLibraryNodeId}"}, method={RequestMethod.GET})
    public JsonChartInstance getChartDetails(@PathVariable Long customReportLibraryNodeId) {
        ChartDefinition chartDef = this.customReportLibraryNodeService.findChartDefinitionByNodeId(customReportLibraryNodeId);
        ChartInstance instance = this.chartService.generateChart(chartDef.getId().longValue(), null, null);
        JsonChartInstance jsonChartInstance = new JsonChartInstance(instance);
        jsonChartInstance.setCustomReportLibraryNodeId(customReportLibraryNodeId);
        return jsonChartInstance;
    }
}

