/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customexport;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.service.customfield.CustomFieldFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportCSVService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomExportWorkbenchData;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.web.backend.controller.customexport.CustomExportCSVHelper;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@Controller
@RequestMapping(value={"/backend/custom-exports"})
public class CustomExportController {
    private final CustomReportCustomExportModificationService customExportModificationService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final CustomReportCustomExportCSVService csvExportService;
    private final CustomFieldFinderService cufService;
    private final CustomFieldValueFinderService cufValueService;
    private final ExecutionStepDao executionStepDao;
    private final InternationalizationHelper i18nHelper;

    public CustomExportController(CustomReportCustomExportModificationService customExportModificationService, CustomReportLibraryNodeService customReportLibraryNodeService, CustomReportCustomExportCSVService csvExportService, CustomFieldFinderService cufService, CustomFieldValueFinderService cufValueService, ExecutionStepDao executionStepDao, InternationalizationHelper i18nHelper) {
        this.customExportModificationService = customExportModificationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.csvExportService = csvExportService;
        this.cufService = cufService;
        this.cufValueService = cufValueService;
        this.executionStepDao = executionStepDao;
        this.i18nHelper = i18nHelper;
    }

    @GetMapping(value={"/workbench/{parentId}"})
    @ResponseBody
    public CustomExportWorkbenchData getWorkbenchData(@PathVariable Long parentId) {
        return this.customExportModificationService.getWorkbenchData(parentId);
    }

    @ResponseBody
    @PostMapping(value={"/new/{parentNodeId}"})
    public Map<String, Long> createNewCustomExport(@RequestBody NewCustomExport newCustomExport, @PathVariable long parentNodeId) {
        CustomReportLibraryNode newNode = this.customReportLibraryNodeService.createNewNode(Long.valueOf(parentNodeId), (CustomReportTreeEntity)newCustomExport.asEntity());
        return Collections.singletonMap("id", newNode.getId());
    }

    @ResponseBody
    @PostMapping(value={"/update/{nodeId}"})
    public Map<String, Long> updateCustomExport(@RequestBody NewCustomExport modifiedCustomExport, @PathVariable long nodeId) {
        this.customExportModificationService.updateCustomExport(Long.valueOf(nodeId), modifiedCustomExport.asEntity());
        return Collections.singletonMap("id", nodeId);
    }

    @ResponseBody
    @GetMapping(value={"/generate/{customExportNodeId}"}, produces={"application/octet-stream"})
    public FileSystemResource generateCustomExport(@PathVariable long customExportNodeId, HttpServletResponse response, Locale locale) {
        CustomReportCustomExport customExport = this.customReportLibraryNodeService.findCustomExportByNodeId(Long.valueOf(customExportNodeId));
        response.setContentType("application/octet-stream");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        response.setHeader("Content-Disposition", "attachment; filename=EXPORT_" + customExport.getName().replace(" ", "_") + "_" + sdf.format(new Date()) + ".csv");
        File exported = this.createCustomExportFile(customExport, locale);
        return new FileSystemResource(exported);
    }

    private File createCustomExportFile(CustomReportCustomExport customExport, Locale locale) {
        CustomExportCSVHelper csvHelper = new CustomExportCSVHelper(this.csvExportService, this.cufService, this.cufValueService, this.i18nHelper, locale, this.executionStepDao);
        try (PrintWriter writer = null;){
            File file = File.createTempFile("custom-export", "tmp");
            file.deleteOnExit();
            writer = new PrintWriter(file);
            writer.write(csvHelper.getInternationalizedHeaders(customExport));
            writer.write(csvHelper.getWritableRowsData(customExport));
            writer.close();
            File file2 = file;
            return file2;
        }
    }

    public static class NewCustomExport {
        private String name;
        private List<NewCustomExportColumn> columns;
        private String scope;

        public CustomReportCustomExport asEntity() {
            CustomReportCustomExport exportEntity = new CustomReportCustomExport();
            exportEntity.setName(this.getName());
            exportEntity.setScope(Collections.singletonList(EntityReference.fromNodeId((String)this.getScope())));
            exportEntity.setColumns(this.columns.stream().map(c -> {
                CustomReportCustomExportColumn columnEntity = new CustomReportCustomExportColumn();
                columnEntity.setLabel(CustomExportColumnLabel.valueOf((String)c.getLabel()));
                columnEntity.setCufId(c.getCufId());
                return columnEntity;
            }).collect(Collectors.toList()));
            return exportEntity;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<NewCustomExportColumn> getColumns() {
            return this.columns;
        }

        public void setColumns(List<NewCustomExportColumn> columns) {
            this.columns = columns;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }
    }

    public static class NewCustomExportColumn {
        private Long cufId;
        private String label;

        public Long getCufId() {
            return this.cufId;
        }

        public void setCufId(Long cufId) {
            this.cufId = cufId;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }
    }
}

