/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customexport;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.persistence.EntityNotFoundException;
import org.jooq.Field;
import org.jooq.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.customreport.CustomExportColumnLabel;
import org.squashtest.tm.domain.customreport.CustomReportCustomExport;
import org.squashtest.tm.domain.customreport.CustomReportCustomExportColumn;
import org.squashtest.tm.service.customfield.CustomFieldFinderService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportCustomExportCSVService;
import org.squashtest.tm.service.internal.repository.ExecutionStepDao;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

public class CustomExportCSVHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomExportCSVHelper.class);
    private static final char SEPARATOR = ';';
    private static final String CARRIAGE_RETURN = "\n";
    private static final String ESCAPED_QUOTE = "\"";
    private static final String NOT_AVAILABLE = "n/a;";
    private static final String SPACE_DASH_SPACE = " - ";
    private CustomReportCustomExportCSVService csvService;
    private CustomFieldFinderService cufService;
    private CustomFieldValueFinderService cufValueService;
    private InternationalizationHelper translator;
    private Locale locale;
    @Inject
    private ExecutionStepDao executionStepDao;

    public CustomExportCSVHelper(CustomReportCustomExportCSVService csvService, CustomFieldFinderService cufService, CustomFieldValueFinderService cufValueService, InternationalizationHelper translator, Locale locale, ExecutionStepDao executionStepDao) {
        this.csvService = csvService;
        this.cufService = cufService;
        this.cufValueService = cufValueService;
        this.translator = translator;
        this.locale = locale;
        this.executionStepDao = executionStepDao;
    }

    public String getInternationalizedHeaders(CustomReportCustomExport customExport) {
        StringBuilder builder = new StringBuilder();
        for (CustomReportCustomExportColumn column : customExport.getColumns()) {
            builder.append(ESCAPED_QUOTE).append(this.buildInternationalizedHeaderLabel(column)).append(ESCAPED_QUOTE).append(';');
        }
        builder.append(CARRIAGE_RETURN);
        return builder.toString();
    }

    private String buildInternationalizedHeaderLabel(CustomReportCustomExportColumn column) {
        CustomExportColumnLabel columnLabel = column.getLabel();
        String internationalizedHeaderName = this.getInternationalizedHeaderName(column);
        return String.valueOf(columnLabel.getShortenedEntityType()) + SPACE_DASH_SPACE + internationalizedHeaderName;
    }

    private String getInternationalizedHeaderName(CustomReportCustomExportColumn column) {
        if (column.getCufId() == null) {
            return this.translator.internationalize(column.getLabel().getI18nKey(), this.locale);
        }
        try {
            return this.cufService.findById(column.getCufId()).getLabel();
        }
        catch (EntityNotFoundException entityNotFoundException) {
            LOGGER.info("Custom Field of ID " + column.getCufId() + " was deleted and will be written as such.");
            return this.translator.internationalize("squashtm.itemdeleted", this.locale);
        }
    }

    public String getWritableRowsData(CustomReportCustomExport customExport) {
        Map<EntityType, List<Long>> entityTypeToCufIdsListMap = this.extractEntityTypeToCufIdsMap(customExport);
        Iterator rowsData = this.csvService.getRowsData(customExport, entityTypeToCufIdsListMap.keySet());
        Object campaignSuccessRate = this.csvService.computeCampaignProgressRate(customExport);
        Map<EntityReference, Map<Long, Object>> cufValuesMapByEntityReference = this.getEntityRefToCufValuesMapMap(customExport, entityTypeToCufIdsListMap);
        return this.buildResultString(rowsData, customExport.getColumns(), cufValuesMapByEntityReference, campaignSuccessRate);
    }

    private Map<EntityType, List<Long>> extractEntityTypeToCufIdsMap(CustomReportCustomExport customExport) {
        return customExport.getColumns().stream().filter(column -> column.getCufId() != null).collect(Collectors.groupingBy(column -> column.getLabel().getEntityType(), Collectors.mapping(CustomReportCustomExportColumn::getCufId, Collectors.toList())));
    }

    private Map<EntityReference, Map<Long, Object>> getEntityRefToCufValuesMapMap(CustomReportCustomExport customExport, Map<EntityType, List<Long>> entityTypeToCufIdsListMap) {
        if (entityTypeToCufIdsListMap.isEmpty()) {
            return new HashMap<EntityReference, Map<Long, Object>>();
        }
        EntityReference entity = (EntityReference)customExport.getScope().get(0);
        return this.cufValueService.getCufValueMapByEntityRef(entity, entityTypeToCufIdsListMap);
    }

    private String buildResultString(Iterator<Record> resultSet, List<CustomReportCustomExportColumn> selectedColumns, Map<EntityReference, Map<Long, Object>> cufMap, Object campaignProgressRate) {
        StringBuilder dataBuilder = new StringBuilder();
        resultSet.forEachRemaining(record -> {
            for (CustomReportCustomExportColumn column : selectedColumns) {
                Object value = this.computeOutputValue((Record)record, column, cufMap, campaignProgressRate);
                if (value != null) {
                    dataBuilder.append(ESCAPED_QUOTE).append(value).append(ESCAPED_QUOTE).append(';');
                    continue;
                }
                dataBuilder.append(NOT_AVAILABLE);
            }
            dataBuilder.append(CARRIAGE_RETURN);
        });
        return dataBuilder.toString();
    }

    private Object computeOutputValue(Record record, CustomReportCustomExportColumn column, Map<EntityReference, Map<Long, Object>> cufMap, Object campaignSuccessRate) {
        CustomExportColumnLabel label = column.getLabel();
        Field columnField = label.getJooqTableField();
        Object value = null;
        if (label.equals((Object)CustomExportColumnLabel.TEST_CASE_NATURE) || label.equals((Object)CustomExportColumnLabel.TEST_CASE_TYPE)) {
            Object i18nKey = record.get(columnField);
            if (i18nKey != null) {
                String i18nKeyString = String.valueOf(i18nKey);
                value = this.translator.getMessage(i18nKeyString, null, i18nKeyString, this.locale);
            }
        } else if (CustomExportColumnLabel.getRichTextFieldsSet().contains(label)) {
            Object rawValue = record.get(columnField);
            value = this.computeRichValue(rawValue);
        } else if (label.equals((Object)CustomExportColumnLabel.CAMPAIGN_PROGRESS_STATUS)) {
            value = campaignSuccessRate;
        } else if (columnField != null) {
            value = record.get(columnField);
        } else {
            EntityReference entityReference;
            Map<Long, Object> cufValuesMap;
            long cufId = column.getCufId();
            EntityType entityType = label.getEntityType();
            Long entityId = (Long)record.get((Field)CustomExportColumnLabel.getEntityTypeToIdTableFieldMap().get(entityType));
            if (entityId != null && (cufValuesMap = cufMap.get(entityReference = new EntityReference(entityType, entityId))) != null) {
                value = this.computeRichValue(cufValuesMap.get(cufId));
            }
        }
        if (value != null && CustomExportColumnLabel.getCustomizableTextFieldsSet().contains(label)) {
            value = this.replaceDoubleQuotes(value.toString());
        }
        return value;
    }

    private String computeRichValue(Object rawValue) {
        if (rawValue == null) {
            return null;
        }
        return HTMLCleanupUtils.htmlToTrimmedText((String)HTMLCleanupUtils.cleanHtml((String)String.valueOf(rawValue)));
    }

    private String replaceDoubleQuotes(String text) {
        return text.replaceAll(ESCAPED_QUOTE, "'");
    }
}

