/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.Collections;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.campaign.CampaignDisplayService;
import org.squashtest.tm.service.internal.display.dto.campaign.CampaignDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.statistics.campaign.CampaignStatisticsBundle;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/campaign-view"})
public class CampaignViewController {
    private CampaignDisplayService campaignDisplayService;
    private CampaignModificationService campaignModificationService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;

    public CampaignViewController(CampaignDisplayService campaignDisplayService, CampaignModificationService campaignModificationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.campaignDisplayService = campaignDisplayService;
        this.campaignModificationService = campaignModificationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
    }

    @RequestMapping(value={"/{campaignId}"}, method={RequestMethod.GET})
    public CampaignDto getCampaignView(@PathVariable long campaignId, Locale locale) {
        CampaignDto dto = this.campaignDisplayService.getCampaignView(campaignId);
        if (dto.isShouldShowFavoriteDashboard() && dto.isCanShowFavoriteDashboard()) {
            EntityReference library = new EntityReference(EntityType.CAMPAIGN, Long.valueOf(campaignId));
            CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
            JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, Collections.singletonList(library), false, Workspace.CAMPAIGN);
            dto.setDashboard(jsonDashboard);
        }
        return dto;
    }

    @RequestMapping(value={"/{campaignId}/statistics"}, method={RequestMethod.GET})
    public CampaignStatisticsBundle getCampaignStatistics(@PathVariable long campaignId) {
        return this.campaignModificationService.gatherCampaignStatisticsBundle(campaignId);
    }
}

