/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.attachment;

import java.beans.PropertyEditorSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.web.multipart.MultipartFile;
import org.squashtest.tm.web.backend.controller.attachment.UploadedData;

public class UploadedDataPropertyEditorSupport
extends PropertyEditorSupport {
    @Override
    public void setValue(Object value) {
        UploadedData data;
        if (value instanceof MultipartFile) {
            MultipartFile multipartFile = (MultipartFile)value;
            try {
                data = new UploadedData(multipartFile.getInputStream(), multipartFile.getOriginalFilename(), multipartFile.getSize());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot read contents of multipart file", ex);
            }
        } else if (value instanceof byte[]) {
            byte[] bval = (byte[])value;
            data = new UploadedData(new ByteArrayInputStream(bval), "anonymous", bval.length);
        } else if (value == null) {
            data = null;
        } else {
            byte[] bval = value.toString().getBytes();
            data = new UploadedData(new ByteArrayInputStream(bval), "anonymous", bval.length);
        }
        super.setValue(data);
    }

    @Override
    public String getAsText() {
        InputStream value = (InputStream)this.getValue();
        return value != null ? value.toString() : "";
    }

    @Override
    public void setAsText(String text) {
    }
}

