/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.team;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.users.Team;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.user.LoginAlreadyExistsException;
import org.squashtest.tm.service.display.team.TeamDisplayService;
import org.squashtest.tm.service.internal.display.dto.ProjectPermissionDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TeamMemberDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.user.CustomTeamModificationService;
import org.squashtest.tm.service.user.TeamModificationService;

@Controller
@RequestMapping(value={"/backend/teams"})
public class TeamsController {
    private TeamDisplayService teamDisplayService;
    private CustomTeamModificationService customTeamModificationService;
    private TeamModificationService teamModificationService;
    private ProjectsPermissionManagementService permissionService;

    @Inject
    public TeamsController(TeamDisplayService teamDisplayService, CustomTeamModificationService customTeamModificationService, TeamModificationService teamModificationService, ProjectsPermissionManagementService permissionService) {
        this.teamDisplayService = teamDisplayService;
        this.customTeamModificationService = customTeamModificationService;
        this.teamModificationService = teamModificationService;
        this.permissionService = permissionService;
    }

    @ResponseBody
    @PostMapping
    public GridResponse getAllTeams(@RequestBody GridRequest request) {
        return this.teamDisplayService.findAll(request);
    }

    @ResponseBody
    @PostMapping(value={"/new"})
    public Map<String, Object> addTeam(@Valid @RequestBody Team team) {
        HashMap<String, Object> tempReturn = new HashMap<String, Object>();
        try {
            this.customTeamModificationService.persist(team);
            tempReturn.put("id", team.getId());
        }
        catch (NameAlreadyInUseException ex) {
            ex.setObjectName("add-team");
            throw ex;
        }
        return tempReturn;
    }

    @RequestMapping(value={"/{teamId}/name"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeName(@PathVariable long teamId, @RequestBody TeamPatch patch) {
        try {
            this.teamModificationService.changeName(teamId, patch.getName());
        }
        catch (LoginAlreadyExistsException loginAlreadyExistsException) {
            NameAlreadyInUseException nameAlreadyInUseEx = new NameAlreadyInUseException("team", "add-team", "name");
            throw nameAlreadyInUseEx;
        }
    }

    @RequestMapping(value={"/{teamId}/description"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeDescription(@PathVariable Long teamId, @RequestBody TeamPatch patch) {
        this.teamModificationService.changeDescription(teamId.longValue(), patch.getDescription());
    }

    @ResponseBody
    @RequestMapping(value={"/{teamIds}"}, method={RequestMethod.DELETE})
    public void deleteTeams(@PathVariable(value="teamIds") List<Long> teamIds) {
        this.customTeamModificationService.deleteTeam(teamIds);
    }

    @ResponseBody
    @RequestMapping(value={"/{teamId}/permissions/{projectIds}"}, method={RequestMethod.POST})
    public Map<String, List<ProjectPermissionDto>> addNewPermissions(@PathVariable long teamId, @PathVariable List<Long> projectIds, @RequestParam String permission) {
        this.permissionService.addNewPermissionToProject(teamId, projectIds, permission);
        return Collections.singletonMap("projectPermissions", this.teamDisplayService.getProjectPermissions(Long.valueOf(teamId)));
    }

    @ResponseBody
    @RequestMapping(value={"/{teamId}/permissions/{projectIds}"}, method={RequestMethod.DELETE})
    public void removePermissions(@PathVariable long teamId, @PathVariable List<Long> projectIds) {
        this.permissionService.removeProjectPermission(teamId, projectIds);
    }

    @RequestMapping(value={"/{teamId}/members/{logins}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, List<TeamMemberDto>> addMembers(@PathVariable long teamId, @PathVariable List<String> logins) {
        this.teamModificationService.addMembers(teamId, logins);
        return Collections.singletonMap("members", this.teamDisplayService.getTeamMembers(Long.valueOf(teamId)));
    }

    @RequestMapping(value={"/{teamId}/members/{memberIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeMember(@PathVariable long teamId, @PathVariable(value="memberIds") List<Long> memberIds) {
        this.teamModificationService.removeMembers(teamId, memberIds);
    }

    static class TeamPatch {
        private String name;
        private String description;

        TeamPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

