/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.exception.requirement.VerifiedRequirementException;
import org.squashtest.tm.exception.requirement.link.LinkedRequirementVersionException;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionLinkDto;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.web.backend.helper.LinkedRequirementVersionActionSummaryBuilder;

@Controller
@RequestMapping(value={"backend/requirement-version/{requirementVersionId}/linked-requirement-versions"})
public class LinkedRequirementVersionsManagerController {
    private static final String IS_RELATED_ID_A_NODE_ID = "isRelatedIdANodeId";
    private static final String REQUIREMENT_VERSION_ID = "requirementVersionId";
    private final LinkedRequirementVersionManagerService linkedReqVersionManager;
    private final RequirementDisplayService requirementDisplayService;

    public LinkedRequirementVersionsManagerController(LinkedRequirementVersionManagerService linkedReqVersionManager, RequirementDisplayService requirementDisplayService) {
        this.linkedReqVersionManager = linkedReqVersionManager;
        this.requirementDisplayService = requirementDisplayService;
    }

    @ResponseBody
    @PostMapping
    public ChangeLinkedRequirementOperationReport addLinkWithVersionIdAndNodeId(@PathVariable(value="requirementVersionId") long requirementVersionId, @RequestBody RequirementVersionLinkPatch requirementVersionLinkPatch) {
        HashMap<String, Object> summary = new HashMap<String, Object>();
        for (Long ids : requirementVersionLinkPatch.requirementNodesIds) {
            Collection rejections = this.linkedReqVersionManager.addLinkWithNodeIds(Long.valueOf(requirementVersionId), ids, requirementVersionLinkPatch.reqVersionLinkTypeId.longValue(), requirementVersionLinkPatch.reqVersionLinkTypeDirection);
            summary.putAll(this.buildSummary(rejections));
        }
        List requirementVersionLinks = this.requirementDisplayService.findLinkedRequirementsByRequirementVersionId(Long.valueOf(requirementVersionId));
        ChangeLinkedRequirementOperationReport report = new ChangeLinkedRequirementOperationReport(requirementVersionLinks);
        report.setSummary(summary);
        return report;
    }

    @ResponseBody
    @GetMapping(value={"/{relatedIds}"})
    public Map<String, String> getRequirementVersionInformation(@PathVariable List<Long> relatedIds) {
        return this.requirementDisplayService.findRequirementVersionNamesByRequirementIds(relatedIds);
    }

    @ResponseBody
    @DeleteMapping(value={"/{requirementLinkIds}"})
    public ChangeLinkedRequirementOperationReport removeLinkedRequirementsFromRequirement(@PathVariable(value="requirementVersionId") long requirementVersionId, @PathVariable(value="requirementLinkIds") List<Long> requirementLinkIds) {
        this.linkedReqVersionManager.removeLinkedRequirementVersionsFromRequirementVersion(requirementVersionId, requirementLinkIds);
        List requirementVersionLinkDtos = this.requirementDisplayService.findLinkedRequirementsByRequirementVersionId(Long.valueOf(requirementVersionId));
        return new ChangeLinkedRequirementOperationReport(requirementVersionLinkDtos);
    }

    @ResponseBody
    @PostMapping(value={"/update"})
    public List<RequirementVersionLinkDto> updateLinkTypeAndDirection(@PathVariable(value="requirementVersionId") long requirementVersionId, @RequestBody RequirementVersionLinkPatch requirementVersionLinkPatch) {
        for (Long paramRelatedId : requirementVersionLinkPatch.requirementNodesIds) {
            long relatedId = paramRelatedId;
            this.linkedReqVersionManager.updateLinkTypeAndDirection(requirementVersionId, relatedId, requirementVersionLinkPatch.isRelatedIdANodeId, requirementVersionLinkPatch.reqVersionLinkTypeId.longValue(), requirementVersionLinkPatch.reqVersionLinkTypeDirection);
        }
        return this.requirementDisplayService.findLinkedRequirementsByRequirementVersionId(Long.valueOf(requirementVersionId));
    }

    private Map<String, Object> buildSummary(Collection<LinkedRequirementVersionException> rejections) {
        return LinkedRequirementVersionActionSummaryBuilder.buildAddActionSummary(rejections);
    }

    static class ChangeLinkedRequirementOperationReport {
        private List<RequirementVersionLinkDto> requirementVersionLinks;
        private Map<String, Object> summary;
        private Map<Long, VerifiedRequirementException> exceptions;

        public ChangeLinkedRequirementOperationReport(List<RequirementVersionLinkDto> requirementVersionLinkDtos) {
            this.requirementVersionLinks = requirementVersionLinkDtos;
        }

        public List<RequirementVersionLinkDto> getRequirementVersionLinks() {
            return this.requirementVersionLinks;
        }

        public void setRequirementVersionLinks(List<RequirementVersionLinkDto> requirementVersionLinkDtos) {
            this.requirementVersionLinks = requirementVersionLinkDtos;
        }

        public Map<String, Object> getSummary() {
            return this.summary;
        }

        public void setSummary(Map<String, Object> summary) {
            this.summary = summary;
        }

        public Map<Long, VerifiedRequirementException> getExceptions() {
            return this.exceptions;
        }

        public void setExceptions(Map<Long, VerifiedRequirementException> exceptions) {
            this.exceptions = exceptions;
        }
    }

    static class RequirementVersionLinkPatch {
        private List<Long> requirementNodesIds;
        private Long reqVersionLinkTypeId;
        private boolean reqVersionLinkTypeDirection;
        private boolean isRelatedIdANodeId;

        RequirementVersionLinkPatch() {
        }

        public List<Long> getRequirementNodesIds() {
            return this.requirementNodesIds;
        }

        public void setRequirementNodesIds(List<Long> requirementNodesIds) {
            this.requirementNodesIds = requirementNodesIds;
        }

        public Long getReqVersionLinkTypeId() {
            return this.reqVersionLinkTypeId;
        }

        public void setReqVersionLinkTypeId(Long reqVersionLinkTypeId) {
            this.reqVersionLinkTypeId = reqVersionLinkTypeId;
        }

        public boolean isReqVersionLinkTypeDirection() {
            return this.reqVersionLinkTypeDirection;
        }

        public void setReqVersionLinkTypeDirection(boolean reqVersionLinkTypeDirection) {
            this.reqVersionLinkTypeDirection = reqVersionLinkTypeDirection;
        }

        public boolean isRelatedIdANodeId() {
            return this.isRelatedIdANodeId;
        }

        public void setRelatedIdANodeId(boolean relatedIdANodeId) {
            this.isRelatedIdANodeId = relatedIdANodeId;
        }
    }
}

