/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.milestone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.NameAlreadyInUseException;
import org.squashtest.tm.exception.milestone.MilestoneLabelAlreadyExistsException;
import org.squashtest.tm.service.display.milestone.MilestoneDisplayService;
import org.squashtest.tm.service.internal.display.dto.BindableProjectToMilestoneDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneDto;
import org.squashtest.tm.service.internal.display.dto.MilestoneProjectViewDto;
import org.squashtest.tm.service.internal.display.dto.ProjectInfoForMilestoneAdminViewDto;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.milestone.CustomMilestoneManager;
import org.squashtest.tm.service.milestone.MilestoneBindingManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.backend.controller.form.model.MilestoneFormModel;

@Controller
@RequestMapping(value={"/backend/milestone-binding"})
public class MilestoneBindingController {
    private CustomMilestoneManager customMilestoneManager;
    private MilestoneBindingManagerService milestoneBindingManagerService;
    private PermissionEvaluationService permissionEvaluationService;
    private ProjectFinder projectFinder;
    private MilestoneDisplayService milestoneDisplayService;

    @Inject
    MilestoneBindingController(CustomMilestoneManager customMilestoneManager, MilestoneBindingManagerService milestoneBindingManagerService, PermissionEvaluationService permissionEvaluationService, ProjectFinder projectFinder, MilestoneDisplayService milestoneDisplayService) {
        this.customMilestoneManager = customMilestoneManager;
        this.milestoneBindingManagerService = milestoneBindingManagerService;
        this.permissionEvaluationService = permissionEvaluationService;
        this.projectFinder = projectFinder;
        this.milestoneDisplayService = milestoneDisplayService;
    }

    @RequestMapping(value={"/project/{projectId}/bind-milestones/{milestoneIds}"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindMilestonesToProject(@PathVariable Long projectId, @PathVariable List<Long> milestoneIds) {
        this.milestoneBindingManagerService.bindMilestonesToProject(milestoneIds, projectId);
    }

    @RequestMapping(value={"/project/{projectId}/bind-milestones-to-project-and-objects/{milestoneIds}"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindMilestonesToProjectAndObjects(@PathVariable Long projectId, @PathVariable List<Long> milestoneIds) {
        this.milestoneBindingManagerService.bindMilestonesToProjectAndBindObject(projectId, milestoneIds);
    }

    @RequestMapping(value={"/project/{projectId}/unbind-milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindMilestonesFromProject(@PathVariable long projectId, @PathVariable List<Long> milestoneIds) {
        this.milestoneBindingManagerService.unbindMilestonesFromProject(milestoneIds, Long.valueOf(projectId));
    }

    @RequestMapping(value={"/{milestoneId}/bind-projects/{projectIds}"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, List<ProjectInfoForMilestoneAdminViewDto>> bindProjectsToMilestone(@PathVariable Long milestoneId, @PathVariable List<Long> projectIds) {
        this.milestoneBindingManagerService.bindProjectsToMilestone(projectIds, milestoneId);
        MilestoneAdminViewDto milestone = this.milestoneDisplayService.getMilestoneView(milestoneId.longValue());
        return Collections.singletonMap("boundProjectsInformation", milestone.getBoundProjectsInformation());
    }

    @RequestMapping(value={"/{milestoneId}/unbind-projects/{projectIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindProjectsFromMilestone(@PathVariable Long milestoneId, @PathVariable List<Long> projectIds) {
        this.milestoneBindingManagerService.unbindProjectsFromMilestone(projectIds, milestoneId);
    }

    @RequestMapping(value={"/{milestoneId}/unbind-projects-and-keep-in-perimeter/{projectIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindProjectFromMilestoneKeepInPerimeter(@PathVariable(value="milestoneId") Long milestoneId, @PathVariable(value="projectIds") List<Long> projectIds) {
        this.milestoneBindingManagerService.unbindProjectsFromMilestoneKeepInPerimeter(projectIds, milestoneId);
    }

    @RequestMapping(value={"/{milestoneId}/bindable-projects"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, List<BindableProjectToMilestoneDto>> getBindableProjectsForMilestone(@PathVariable long milestoneId) {
        List projects = this.milestoneBindingManagerService.getAllBindableProjectForMilestone(Long.valueOf(milestoneId));
        ArrayList bindableProjects = new ArrayList();
        projects.forEach(project -> {
            BindableProjectToMilestoneDto bindableProjectDto = new BindableProjectToMilestoneDto();
            bindableProjectDto.setId(project.getId());
            bindableProjectDto.setName(project.getName());
            bindableProjectDto.setLabel(project.getLabel());
            bindableProjectDto.setTemplate(ProjectHelper.isTemplate((GenericProject)project));
            bindableProjects.add(bindableProjectDto);
        });
        return Collections.singletonMap("bindableProjects", bindableProjects);
    }

    @RequestMapping(value={"/project/{projectId}/create-milestone-and-bind-to-project"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> createAndBindMilestoneToProject(@PathVariable Long projectId, @Valid @RequestBody MilestoneFormModel milestoneFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Milestone milestone = this.createMilestone(milestoneFormModel);
        MilestoneProjectViewDto milestoneProjectViewDto = this.prepareServerResponseAfterCreatingMilestone(milestone);
        milestoneProjectViewDto.setMilestoneBoundToOneObjectOfProject(false);
        response.put("milestone", milestoneProjectViewDto);
        this.milestoneBindingManagerService.bindMilestonesToProject(Collections.singletonList(milestone.getId()), projectId);
        return response;
    }

    @RequestMapping(value={"/project/{projectId}/create-milestone-and-bind-to-project-and-objects"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> createAndBindMilestoneToProjectAndObjects(@PathVariable Long projectId, @Valid @RequestBody MilestoneFormModel milestoneFormModel) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        Milestone milestone = this.createMilestone(milestoneFormModel);
        MilestoneProjectViewDto milestoneProjectViewDto = this.prepareServerResponseAfterCreatingMilestone(milestone);
        milestoneProjectViewDto.setMilestoneBoundToOneObjectOfProject(true);
        response.put("milestone", milestoneProjectViewDto);
        this.milestoneBindingManagerService.bindMilestonesToProjectAndBindObject(projectId, Collections.singletonList(milestone.getId()));
        return response;
    }

    private Milestone createMilestone(MilestoneFormModel milestoneFormModel) {
        Milestone milestone = milestoneFormModel.getMilestone();
        this.setRange(milestone);
        this.setPerimeter(milestone);
        try {
            this.customMilestoneManager.addMilestone(milestone);
        }
        catch (MilestoneLabelAlreadyExistsException milestoneLabelAlreadyExistsException) {
            throw new NameAlreadyInUseException("Milestone", milestoneFormModel.getLabel(), "label");
        }
        return milestone;
    }

    private MilestoneProjectViewDto prepareServerResponseAfterCreatingMilestone(Milestone milestone) {
        MilestoneProjectViewDto response = new MilestoneProjectViewDto();
        MilestoneDto milestoneDto = new MilestoneDto();
        milestoneDto.setId(milestone.getId());
        milestoneDto.setLabel(milestone.getLabel());
        String sanitizedDescription = HTMLCleanupUtils.htmlToTrimmedText((String)milestone.getDescription());
        milestoneDto.setDescription(sanitizedDescription);
        milestoneDto.setEndDate(milestone.getEndDate());
        milestoneDto.setOwnerFirstName(milestone.getOwner().getFirstName());
        milestoneDto.setOwnerLastName(milestone.getOwner().getLastName());
        milestoneDto.setOwnerLogin(milestone.getOwner().getLogin());
        milestoneDto.setStatus(milestone.getStatus().name());
        milestoneDto.setRange(milestone.getRange().name());
        response.setMilestone(milestoneDto);
        return response;
    }

    private void setRange(Milestone milestone) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(MilestoneRange.GLOBAL);
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
    }

    private void setPerimeter(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            List projects = this.projectFinder.findAllICanManage();
            milestone.addProjectsToPerimeter(projects);
        }
    }
}

