/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.home;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.system.SystemAdministrationService;

@RestController
@RequestMapping(value={"backend/login-page"})
public class LoginPageController {
    private final SystemAdministrationService systemAdministrationService;
    @Value(value="${info.app.version}")
    private String version;
    @Autowired
    private Environment environment;

    public LoginPageController(SystemAdministrationService systemAdministrationService) {
        this.systemAdministrationService = systemAdministrationService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public WelcomePageData loadLoginPage() {
        String loginMessage = this.systemAdministrationService.findLoginMessage();
        boolean isH2 = this.isH2();
        return new WelcomePageData(loginMessage, this.version, isH2);
    }

    private boolean isH2() {
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        return activeProfiles.contains("h2");
    }

    static class WelcomePageData {
        private final String loginMessage;
        private final String squashVersion;
        private final boolean isH2;

        public WelcomePageData(String loginMessage, String squashVersion, boolean isH2) {
            this.loginMessage = HTMLCleanupUtils.cleanHtml((String)loginMessage);
            this.squashVersion = squashVersion;
            this.isH2 = isH2;
        }

        public String getLoginMessage() {
            return this.loginMessage;
        }

        public String getSquashVersion() {
            return this.squashVersion;
        }

        @JsonProperty(value="isH2")
        public boolean isH2() {
            return this.isH2;
        }
    }
}

