/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.form.model;

import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.CustomFieldOption;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.domain.customfield.MultiSelectField;
import org.squashtest.tm.domain.customfield.NumericField;
import org.squashtest.tm.domain.customfield.RichTextField;
import org.squashtest.tm.domain.customfield.SingleSelectField;

public class CustomFieldFormModel {
    private String name;
    private String label;
    private String code;
    private InputType inputType;
    private boolean optional;
    private String[][] options;
    private String defaultValue;

    public CustomField getCustomField() {
        CustomField customField;
        switch (this.inputType) {
            case DROPDOWN_LIST: {
                customField = this.createSingleSelectField();
                break;
            }
            case RICH_TEXT: {
                customField = this.createRichTextField();
                break;
            }
            case TAG: {
                customField = this.createTag();
                break;
            }
            case NUMERIC: {
                customField = this.createNumeric();
                break;
            }
            default: {
                customField = new CustomField(this.inputType);
            }
        }
        customField.setCode(this.code);
        customField.setLabel(this.label);
        customField.setName(this.name);
        customField.setOptional(this.optional);
        customField.setDefaultValue(this.defaultValue);
        return customField;
    }

    private CustomField createNumeric() {
        return new NumericField();
    }

    private CustomField createSingleSelectField() {
        SingleSelectField ssf = new SingleSelectField();
        String[][] stringArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            String[] option = stringArray[n2];
            String label = option[0];
            String code = option[1];
            String colour = option[2];
            ssf.addOption(new CustomFieldOption(label, code, colour));
            ++n2;
        }
        SingleSelectField res = ssf;
        return res;
    }

    private CustomField createRichTextField() {
        return new RichTextField();
    }

    private CustomField createTag() {
        return new MultiSelectField();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setInputType(InputType inputType) {
        this.inputType = inputType;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setOptions(String[][] options) {
        this.options = options;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

