/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import java.util.Objects;
import javax.inject.Inject;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.exception.ActionException;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.exception.execution.IterationTestPlanHasDeletedTestCaseException;
import org.squashtest.tm.service.campaign.TestPlanExecutionProcessingService;
import org.squashtest.tm.service.internal.display.dto.execution.TestPlanResume;
import org.squashtest.tm.web.backend.controller.execution.AbstractTestPlanExecutionRunnerController;

@RestController
@RequestMapping(value={"/backend/test-suite/{testSuiteId}/test-plan"})
public class TestSuiteExecutionRunnerController
extends AbstractTestPlanExecutionRunnerController<TestSuite> {
    @Inject
    private TestPlanExecutionProcessingService<TestSuite> testSuiteExecutionProcessingService;

    @RequestMapping(value={"/resume"}, method={RequestMethod.POST})
    public TestPlanResume.TestSuiteTestPlanResume resumeTestSuite(@PathVariable long testSuiteId) {
        Execution execution = super.startResume(testSuiteId);
        boolean hasNextTestCase = this.hasNextTestCase(testSuiteId, execution);
        return new TestPlanResume.TestSuiteTestPlanResume(Long.valueOf(testSuiteId), execution, hasNextTestCase);
    }

    @RequestMapping(value={"/relaunch"}, method={RequestMethod.POST})
    public TestPlanResume.TestSuiteTestPlanResume relaunchTestSuite(@PathVariable long testSuiteId) {
        Execution execution = super.relaunch(testSuiteId);
        boolean hasNextTestCase = this.hasNextTestCase(testSuiteId, execution);
        return new TestPlanResume.TestSuiteTestPlanResume(Long.valueOf(testSuiteId), execution, hasNextTestCase);
    }

    @Override
    ActionException getTestPlanHasDeletedTestCaseException() {
        return new IterationTestPlanHasDeletedTestCaseException();
    }

    @RequestMapping(value={"/{testPlanItemId}/next-execution"})
    public TestPlanResume.TestSuiteTestPlanResume moveToNextTestCase(@PathVariable(value="testPlanItemId") long testPlanItemId, @PathVariable(value="testSuiteId") long testSuiteId) {
        Execution execution = this.testPlanExecutionRunner.startResumeNextExecution(testSuiteId, testPlanItemId);
        boolean hasNextTestCase = this.hasNextTestCase(testSuiteId, execution);
        return new TestPlanResume.TestSuiteTestPlanResume(Long.valueOf(testSuiteId), execution, hasNextTestCase);
    }

    private boolean hasNextTestCase(long testSuiteId, Execution execution) {
        boolean hasNextTestCase = false;
        if (Objects.nonNull(execution)) {
            hasNextTestCase = this.testSuiteExecutionProcessingService.hasMoreExecutableItems(testSuiteId, execution.getTestPlan().getId().longValue());
        }
        return hasNextTestCase;
    }

    @Override
    boolean hasDeletedTestCaseInTestPlan(long testSuiteId) {
        return ((TestSuite)this.entityFinder.findById(testSuiteId)).getTestPlan().stream().anyMatch(c -> c.getReferencedTestCase() == null);
    }
}

