/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.execution;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.service.campaign.CustomIterationModificationService;
import org.squashtest.tm.service.display.execution.ExecutionDisplayService;
import org.squashtest.tm.service.execution.ExecutionModificationService;
import org.squashtest.tm.service.internal.display.dto.execution.ActionStepExecView;
import org.squashtest.tm.service.internal.display.dto.execution.ExecutionView;
import org.squashtest.tm.service.internal.display.dto.execution.ModificationDuringExecutionView;
import org.squashtest.tm.web.backend.controller.form.model.CreatedEntityId;

@RestController
@RequestMapping(value={"/backend/execution/{executionId}"})
public class ExecutionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionController.class);
    private final ExecutionDisplayService executionDisplayService;
    private final ExecutionModificationService executionModificationService;
    private final CustomIterationModificationService itpService;

    public ExecutionController(ExecutionDisplayService executionDisplayService, ExecutionModificationService executionModificationService, CustomIterationModificationService itpService) {
        this.executionDisplayService = executionDisplayService;
        this.executionModificationService = executionModificationService;
        this.itpService = itpService;
    }

    @GetMapping
    public ExecutionView getExecutionView(@PathVariable(value="executionId") long executionId) {
        return this.executionDisplayService.findOne(Long.valueOf(executionId));
    }

    @GetMapping(value={"/modification-during-execution/permissions"})
    public void checkPermissions(@PathVariable long executionId) {
        this.executionDisplayService.checkPermissionsForModificationDuringExecutionPrologue(executionId);
    }

    @GetMapping(value={"/modification-during-execution/permissions/{stepId}"})
    public void checkPermissions(@PathVariable long executionId, @PathVariable long stepId) {
        this.executionDisplayService.checkPermissionsForModificationDuringExecution(executionId, stepId);
    }

    @GetMapping(value={"/modification-during-execution"})
    public ModificationDuringExecutionView getModificationDuringExecutionView(@PathVariable long executionId) {
        return this.executionDisplayService.findOneForModificationDuringExec(Long.valueOf(executionId));
    }

    @GetMapping(value={"/modification-during-execution/action-step/{stepId}"})
    public ActionStepExecView getActionStepDuringExecutionView(@PathVariable long executionId, @PathVariable long stepId) {
        return this.executionDisplayService.findOneActionStepForModificationDuringExec(executionId, stepId);
    }

    @RequestMapping(value={"/modification-during-execution/update-steps"}, method={RequestMethod.POST})
    @ResponseBody
    public Long updateSteps(@PathVariable(value="executionId") long executionId) {
        return this.executionModificationService.updateSteps(executionId);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/comment"})
    @ResponseBody
    public void updateComment(@RequestBody ExecutionPatch executionPatch, @PathVariable long executionId) {
        this.executionModificationService.setExecutionDescription(Long.valueOf(executionId), executionPatch.comment);
        LOGGER.trace("Execution " + executionId + ": updated description to " + executionPatch.comment);
    }

    @RequestMapping(value={"/update-from-tc"}, method={RequestMethod.POST})
    public CreatedEntityId updateExecutionFromTc(@PathVariable long executionId) {
        Execution exec = this.itpService.updateExecutionFromTc(executionId);
        return new CreatedEntityId(exec.getId());
    }

    static class ExecutionPatch {
        private String comment;

        ExecutionPatch() {
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

