/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import java.util.List;
import java.util.Locale;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.customreport.DashboardDisplayService;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;
import org.squashtest.tm.web.backend.model.json.JsonDynamicScope;

@RestController
@RequestMapping(value={"/backend/dashboard-view"})
public class DashboardViewController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final DashboardDisplayService dashboardDisplayService;

    public DashboardViewController(CustomReportLibraryNodeService customReportLibraryNodeService, @Named(value="customReport.dashboardBuilder") Provider<JsonCustomReportDashboardBuilder> builderProvider, DashboardDisplayService dashboardDisplayService) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
        this.dashboardDisplayService = dashboardDisplayService;
    }

    @ResponseBody
    @RequestMapping(value={"/{customReportLibraryNodeId}"}, method={RequestMethod.GET})
    public JsonCustomReportDashboard getDashboardDetails(@PathVariable Long customReportLibraryNodeId, Locale locale) {
        CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(customReportLibraryNodeId);
        JsonCustomReportDashboard jsonCustomReportDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(customReportLibraryNodeId, dashboard, locale);
        jsonCustomReportDashboard.setFavoriteWorkspaces(this.dashboardDisplayService.findFavoriteWorkspaceForDashboardAndCurrentUser(jsonCustomReportDashboard.getCustomReportLibraryNodeId()));
        return jsonCustomReportDashboard;
    }

    @ResponseBody
    @RequestMapping(value={"{customReportLibraryNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportDashboard getDashboardDetailsWithDynamicScope(@PathVariable Long customReportLibraryNodeId, Locale locale, @RequestBody JsonDynamicScope dynamicScope) {
        List<EntityReference> entityReferences = dynamicScope.convertToEntityReferences();
        CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(customReportLibraryNodeId);
        Workspace workspace = Workspace.valueOf((String)dynamicScope.getWorkspaceName());
        return ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(customReportLibraryNodeId, dashboard, locale, entityReferences, dynamicScope.isMilestoneDashboard(), workspace);
    }
}

