/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.customreport;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportChartBinding;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportReportBinding;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.customreport.DashboardDisplayService;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportChartBinding;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportReportBinding;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportChartBindingBuilder;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportReportBindingBuilder;

@RestController
@RequestMapping(value={"/backend/dashboard"})
public class DashboardModificationController {
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    private final CustomReportDashboardService dashboardService;
    private final Provider<JsonCustomReportChartBindingBuilder> chartBindingBuilderProvider;
    private final Provider<JsonCustomReportReportBindingBuilder> reportBindingBuilderProvider;
    private final DashboardDisplayService dashboardDisplayService;

    public DashboardModificationController(CustomReportLibraryNodeService customReportLibraryNodeService, CustomReportDashboardService customReportDashboardService, Provider<JsonCustomReportChartBindingBuilder> chartBindingBuilderProvider, Provider<JsonCustomReportReportBindingBuilder> reportBindingBuilderProvider, DashboardDisplayService dashboardDisplayService) {
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.dashboardService = customReportDashboardService;
        this.chartBindingBuilderProvider = chartBindingBuilderProvider;
        this.reportBindingBuilderProvider = reportBindingBuilderProvider;
        this.dashboardDisplayService = dashboardDisplayService;
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{dashboardEntityId}/name"})
    public void rename(@PathVariable long dashboardEntityId, @RequestBody DashboardPatch patch) {
        this.customReportLibraryNodeService.renameNode(Long.valueOf(dashboardEntityId), patch.getName(), CustomReportDashboard.class);
    }

    @RequestMapping(value={"/{dashboardEntityId}/chart-binding"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsonCustomReportChartBinding createChartBinding(@PathVariable long dashboardEntityId, @RequestBody ChartBindingForm formChartBinding) {
        CustomReportChartBinding chartBinding = formChartBinding.convertToEntity();
        this.dashboardService.bindChart(chartBinding, formChartBinding.getChartDefinitionNodeId(), Long.valueOf(dashboardEntityId));
        return ((JsonCustomReportChartBindingBuilder)this.chartBindingBuilderProvider.get()).build(chartBinding);
    }

    @RequestMapping(value={"/{dashboardEntityId}/report-binding"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    public JsonCustomReportReportBinding createReportBinding(@PathVariable long dashboardEntityId, @RequestBody ReportBindingForm formReportBinding) {
        CustomReportReportBinding reportBinding = formReportBinding.convertToEntity();
        this.dashboardService.bindReport(reportBinding, formReportBinding.getReportDefinitionNodeId(), Long.valueOf(dashboardEntityId));
        return ((JsonCustomReportReportBindingBuilder)this.reportBindingBuilderProvider.get()).build(reportBinding);
    }

    @ResponseBody
    @RequestMapping(value={"/chart-binding/{id}/swap/{chartNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportChartBinding swapChart(@PathVariable long id, @PathVariable long chartNodeId) {
        CustomReportChartBinding chartBinding = this.dashboardService.changeBindedChart(id, chartNodeId);
        return ((JsonCustomReportChartBindingBuilder)this.chartBindingBuilderProvider.get()).build(chartBinding);
    }

    @ResponseBody
    @RequestMapping(value={"/report-binding/{id}/swap/{reportNodeId}"}, method={RequestMethod.POST})
    public JsonCustomReportReportBinding swapReport(@PathVariable long id, @PathVariable long reportNodeId) {
        CustomReportReportBinding reportBinding = this.dashboardService.changeBindedReport(id, reportNodeId);
        return ((JsonCustomReportReportBindingBuilder)this.reportBindingBuilderProvider.get()).build(reportBinding);
    }

    @ResponseBody
    @RequestMapping(value={"/bindings"}, method={RequestMethod.POST})
    public void updateGrid(@RequestBody GridPositionUpdate gridElements) {
        List<CustomReportChartBinding> chartBindings = this.extractChartBindings(gridElements);
        List<CustomReportReportBinding> reportBindings = this.extractReportBindings(gridElements);
        this.dashboardService.updateGridPosition(chartBindings, reportBindings);
    }

    @ResponseBody
    @RequestMapping(value={"/chart-binding/{id}"}, method={RequestMethod.DELETE})
    public void unbindChart(@PathVariable long id) {
        this.dashboardService.unbindChart(Long.valueOf(id));
    }

    @ResponseBody
    @RequestMapping(value={"/report-binding/{id}"}, method={RequestMethod.DELETE})
    public void unbindReport(@PathVariable long id) {
        this.dashboardService.unbindReport(Long.valueOf(id));
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/favorite/{workspace}/{dashboardId}"})
    @ResponseBody
    public DashboardFavoriteWorkspaces changeFavoriteDashboard(@PathVariable long dashboardId, @PathVariable String workspace) {
        Workspace workspaceId = Workspace.valueOf((String)workspace);
        this.dashboardService.chooseFavoriteDashboardForCurrentUser(workspaceId, dashboardId);
        return new DashboardFavoriteWorkspaces(this.dashboardDisplayService.findFavoriteWorkspaceForDashboardAndCurrentUser(Long.valueOf(dashboardId)));
    }

    @DeleteMapping(value={"/favorite/{dashboardId}"})
    @ResponseBody
    public void removeDashboardFromFavorites(@PathVariable long dashboardId) {
        this.dashboardService.removeDashboardFromFavoritesForCurrentUser(dashboardId);
    }

    private List<CustomReportReportBinding> extractReportBindings(GridPositionUpdate gridElements) {
        return gridElements.getReports().stream().map(ReportBindingForm::convertToEntity).collect(Collectors.toList());
    }

    private List<CustomReportChartBinding> extractChartBindings(GridPositionUpdate gridElements) {
        return gridElements.getCharts().stream().map(ChartBindingForm::convertToEntity).collect(Collectors.toList());
    }

    static class ChartBindingForm
    extends DashboardBindingForm {
        private Long chartDefinitionNodeId;

        ChartBindingForm() {
        }

        public Long getChartDefinitionNodeId() {
            return this.chartDefinitionNodeId;
        }

        public void setChartDefinitionNodeId(Long chartDefinitionNodeId) {
            this.chartDefinitionNodeId = chartDefinitionNodeId;
        }

        public CustomReportChartBinding convertToEntity() {
            CustomReportChartBinding chartBinding = new CustomReportChartBinding();
            chartBinding.setId(this.id);
            chartBinding.setCol(this.col);
            chartBinding.setRow(this.row);
            chartBinding.setSizeX(this.sizeX);
            chartBinding.setSizeY(this.sizeY);
            return chartBinding;
        }
    }

    static abstract class DashboardBindingForm {
        protected Long id;
        protected int row;
        protected int col;
        protected int sizeX;
        protected int sizeY;

        DashboardBindingForm() {
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public int getSizeX() {
            return this.sizeX;
        }

        public void setSizeX(int sizeX) {
            this.sizeX = sizeX;
        }

        public int getSizeY() {
            return this.sizeY;
        }

        public void setSizeY(int sizeY) {
            this.sizeY = sizeY;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }

    static class DashboardFavoriteWorkspaces {
        private List<Workspace> workspaces;

        public DashboardFavoriteWorkspaces(List<Workspace> workspaces) {
            this.workspaces = workspaces;
        }

        public List<Workspace> getWorkspaces() {
            return this.workspaces;
        }
    }

    static class DashboardPatch {
        private String name;

        DashboardPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    static class GridPositionUpdate {
        private List<ChartBindingForm> charts = new ArrayList<ChartBindingForm>();
        private List<ReportBindingForm> reports = new ArrayList<ReportBindingForm>();

        GridPositionUpdate() {
        }

        public List<ChartBindingForm> getCharts() {
            return this.charts;
        }

        public void setCharts(List<ChartBindingForm> charts) {
            this.charts = charts;
        }

        public List<ReportBindingForm> getReports() {
            return this.reports;
        }

        public void setReports(List<ReportBindingForm> reports) {
            this.reports = reports;
        }
    }

    static class ReportBindingForm
    extends DashboardBindingForm {
        private Long reportDefinitionNodeId;

        ReportBindingForm() {
        }

        public Long getReportDefinitionNodeId() {
            return this.reportDefinitionNodeId;
        }

        public void setReportDefinitionNodeId(Long reportDefinitionNodeId) {
            this.reportDefinitionNodeId = reportDefinitionNodeId;
        }

        public CustomReportReportBinding convertToEntity() {
            CustomReportReportBinding reportBinding = new CustomReportReportBinding();
            reportBinding.setId(this.id);
            reportBinding.setCol(this.col);
            reportBinding.setRow(this.row);
            reportBinding.setSizeX(this.sizeX);
            reportBinding.setSizeY(this.sizeY);
            return reportBinding;
        }
    }
}

