/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.campaign.TestSuiteModificationService;

@RestController
@RequestMapping(value={"backend/test-suite/{testSuiteId}"})
public class TestSuiteModificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuiteModificationController.class);
    private TestSuiteModificationService testSuiteModificationService;

    public TestSuiteModificationController(TestSuiteModificationService testSuiteModificationService) {
        this.testSuiteModificationService = testSuiteModificationService;
    }

    @ResponseBody
    @PostMapping(value={"/name"})
    public void rename(@PathVariable Long testSuiteId, @RequestBody TestSuitePatch patch) {
        this.testSuiteModificationService.rename(testSuiteId.longValue(), patch.getName());
    }

    @ResponseBody
    @PostMapping(value={"/description"})
    public void changeDescription(@PathVariable Long testSuiteId, @RequestBody TestSuitePatch patch) {
        this.testSuiteModificationService.changeDescription(testSuiteId.longValue(), patch.getDescription());
    }

    @ResponseBody
    @PostMapping(value={"/execution-status"})
    public void changeExecutionStatus(@PathVariable Long testSuiteId, @RequestBody TestSuitePatch patch) {
        this.testSuiteModificationService.changeExecutionStatus(testSuiteId.longValue(), ExecutionStatus.valueOf((String)patch.getExecutionStatus()));
    }

    static class TestSuitePatch {
        private String name;
        private String description;
        private String executionStatus;

        TestSuitePatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExecutionStatus() {
            return this.executionStatus;
        }

        public void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }
    }
}

