/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.campaign;

import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.web.backend.controller.campaign.CampaignTestPlanManagerController;
import org.squashtest.tm.web.backend.controller.campaign.IterationTestPlanManagerController;

@RestController
@RequestMapping(value={"backend/test-plan-item"})
public class TestPlanItemController {
    private final IterationTestPlanManagerService iterationTestPlanManagerService;
    private final CampaignTestPlanManagerService campaignTestPlanManagerService;

    public TestPlanItemController(IterationTestPlanManagerService iterationTestPlanManagerService, CampaignTestPlanManagerService campaignTestPlanManagerService) {
        this.iterationTestPlanManagerService = iterationTestPlanManagerService;
        this.campaignTestPlanManagerService = campaignTestPlanManagerService;
    }

    @ResponseBody
    @PostMapping(value={"{testPlanItemId}/dataset"})
    public Long setDatasetToIterationTestPlanItem(@PathVariable long testPlanItemId, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.changeDataset(testPlanItemId, patch.getDatasetId());
        return patch.getDatasetId();
    }

    @ResponseBody
    @PostMapping(value={"{testPlanItemId}/dataset-to-ctpi"})
    public Long setDatasetToIterationTestPlanItem(@PathVariable long testPlanItemId, @RequestBody CampaignTestPlanManagerController.CampaignTestPlanItemPatch patch) {
        this.campaignTestPlanManagerService.changeDataset(testPlanItemId, patch.getDatasetId());
        return patch.getDatasetId();
    }

    @ResponseBody
    @PostMapping(value={"/{testPlanItemsIds}/assign-user"})
    public Long assignUserToIterationTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.getAssignee().longValue());
        return patch.getAssignee();
    }

    @ResponseBody
    @PostMapping(value={"/{testPlanItemsIds}/execution-status"})
    public void updateIterationTestPlanItemsStatus(@PathVariable List<Long> testPlanItemsIds, @RequestBody IterationTestPlanManagerController.IterationTestPlanItemPatch patch) {
        this.iterationTestPlanManagerService.forceExecutionStatus(testPlanItemsIds, patch.getExecutionStatus());
    }

    @ResponseBody
    @PostMapping(value={"/{testPlanItemsIds}/assign-user-to-ctpi"})
    public Long assignUserToCampaignTestPlanItem(@PathVariable List<Long> testPlanItemsIds, @RequestBody CampaignTestPlanManagerController.CampaignTestPlanItemPatch patch) {
        this.campaignTestPlanManagerService.assignUserToTestPlanItems(testPlanItemsIds, patch.getAssignee());
        return patch.getAssignee();
    }
}

