/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.bugtracker;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackerModificationService;
import org.squashtest.tm.service.display.bugtracker.BugTrackerDisplayService;
import org.squashtest.tm.service.internal.display.dto.BugTrackerViewDto;
import org.squashtest.tm.service.internal.display.dto.CredentialsDto;
import org.squashtest.tm.service.internal.utils.HTMLCleanupUtils;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.servers.StoredCredentialsManager;

@RestController
@RequestMapping(value={"/backend/bugtracker-view"})
public class BugTrackerViewController {
    private final BugTrackerDisplayService bugTrackerDisplayService;
    private final BugTrackerFinderService bugTrackerFinder;
    private final StoredCredentialsManager credentialsManager;
    private final BugTrackerModificationService bugTrackerModificationService;
    private final BugTrackerFinderService bugTrackerFinderService;

    BugTrackerViewController(BugTrackerDisplayService bugTrackerDisplayService, BugTrackerFinderService bugTrackerFinder, StoredCredentialsManager credentialsManager, BugTrackerModificationService bugTrackerModificationService, BugTrackerFinderService bugTrackerFinderService) {
        this.bugTrackerDisplayService = bugTrackerDisplayService;
        this.bugTrackerFinder = bugTrackerFinder;
        this.credentialsManager = credentialsManager;
        this.bugTrackerModificationService = bugTrackerModificationService;
        this.bugTrackerFinderService = bugTrackerFinderService;
    }

    @GetMapping(value={"/{bugTrackerId}"})
    @ResponseBody
    BugTrackerViewDto getBugTrackerView(@PathVariable Long bugTrackerId) {
        BugTrackerViewDto dto = this.bugTrackerDisplayService.getBugTrackerView(bugTrackerId);
        dto.setBugTrackerKinds(this.findBugTrackerKinds());
        ManageableCredentials credentials = this.credentialsManager.findAppLevelCredentials(bugTrackerId.longValue());
        dto.setCredentials(CredentialsDto.from((ManageableCredentials)credentials));
        ServerAuthConfiguration configuration = this.credentialsManager.findServerAuthConfiguration(bugTrackerId.longValue());
        dto.setAuthConfiguration(configuration);
        List<String> supportedProtocols = this.getSupportedAuthenticationProtocols(bugTrackerId);
        dto.setSupportedAuthenticationProtocols(supportedProtocols);
        return dto;
    }

    private List<String> getSupportedAuthenticationProtocols(Long bugTrackerId) {
        BugTracker bugTracker = this.bugTrackerFinderService.findById(bugTrackerId.longValue());
        return Arrays.stream(this.bugTrackerModificationService.getSupportedProtocols(bugTracker)).map(Enum::name).collect(Collectors.toList());
    }

    private Set<String> findBugTrackerKinds() {
        return this.bugTrackerFinder.findBugTrackerKinds().stream().map(HTMLCleanupUtils::cleanHtml).collect(Collectors.toSet());
    }
}

