/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.jasperreports.processors;

import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import net.sf.jasperreports.engine.base.JRBasePrintHyperlink;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JEditorPaneHtmlMarkupProcessor;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.MarkupProcessor;
import net.sf.jasperreports.engine.util.MarkupProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHtmlProcessorFactory
extends JEditorPaneHtmlMarkupProcessor
implements MarkupProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomHtmlProcessorFactory.class);
    private static CustomHtmlProcessorFactory custom_instance;

    public MarkupProcessor createMarkupProcessor() {
        if (custom_instance == null) {
            custom_instance = new CustomHtmlProcessorFactory();
        }
        return custom_instance;
    }

    protected Map<AttributedCharacterIterator.Attribute, Object> getAttributes(AttributeSet attrSet) {
        Map attributes = super.getAttributes(attrSet);
        if (!attributes.containsKey(TextAttribute.WEIGHT) && this.hasHtmlTag(attrSet, HTML.Tag.STRONG)) {
            attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (!attributes.containsKey(TextAttribute.POSTURE) && this.hasHtmlTag(attrSet, HTML.Tag.EM)) {
            attributes.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        return attributes;
    }

    public boolean hasHtmlTag(AttributeSet attrSet, HTML.Tag tag) {
        Enumeration<?> attrNames = attrSet.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            Object obj = attrNames.nextElement();
            if (!tag.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public String convert(String srcText) {
        JEditorPane editorPane = new JEditorPane("text/html", srcText);
        editorPane.setEditable(false);
        ArrayList elements = new ArrayList();
        Document document = editorPane.getDocument();
        Element root = document.getDefaultRootElement();
        if (root != null) {
            this.addElements(elements, root);
        }
        int startOffset = 0;
        int endOffset = 0;
        int crtOffset = 0;
        String chunk = null;
        JRBasePrintHyperlink hyperlink = null;
        Element element = null;
        boolean bodyOccurred = false;
        int[] orderedListIndex = new int[elements.size()];
        String whitespace = "    ";
        String[] whitespaces = new String[elements.size()];
        int i = 0;
        while (i < elements.size()) {
            whitespaces[i] = "";
            ++i;
        }
        JRStyledText styledText = new JRStyledText();
        int i2 = 0;
        while (i2 < elements.size()) {
            block33: {
                Object object;
                if (bodyOccurred && chunk != null) {
                    styledText.append(chunk);
                    Map<AttributedCharacterIterator.Attribute, Object> styleAttributes = this.getAttributes(element.getAttributes());
                    if (hyperlink != null) {
                        styleAttributes.put((AttributedCharacterIterator.Attribute)JRTextAttribute.HYPERLINK, hyperlink);
                        hyperlink = null;
                    }
                    if (!styleAttributes.isEmpty()) {
                        styledText.addRun(new JRStyledText.Run(styleAttributes, startOffset + crtOffset, endOffset + crtOffset));
                    }
                }
                chunk = null;
                element = (Element)elements.get(i2);
                Element parent = element.getParentElement();
                startOffset = element.getStartOffset();
                endOffset = element.getEndOffset();
                AttributeSet attrs = element.getAttributes();
                Object elementName = attrs.getAttribute("$ename");
                Object object2 = object = elementName != null ? null : attrs.getAttribute(StyleConstants.NameAttribute);
                if (object instanceof HTML.Tag) {
                    HTML.Tag htmlTag = (HTML.Tag)object;
                    if (htmlTag == HTML.Tag.BODY) {
                        bodyOccurred = true;
                        crtOffset = -startOffset;
                    } else if (htmlTag == HTML.Tag.BR) {
                        chunk = "\n";
                    } else if (htmlTag == HTML.Tag.OL) {
                        orderedListIndex[i2] = 0;
                        String parentName = parent.getName().toLowerCase();
                        whitespaces[i2] = String.valueOf(whitespaces[elements.indexOf(parent)]) + whitespace;
                        if ("li".equals(parentName)) {
                            chunk = "";
                        } else {
                            chunk = "\n";
                            ++crtOffset;
                        }
                    } else if (htmlTag == HTML.Tag.UL) {
                        whitespaces[i2] = String.valueOf(whitespaces[elements.indexOf(parent)]) + whitespace;
                        String parentName = parent.getName().toLowerCase();
                        if ("li".equals(parentName)) {
                            chunk = "";
                        } else {
                            chunk = "\n";
                            ++crtOffset;
                        }
                    } else if (htmlTag == HTML.Tag.LI) {
                        whitespaces[i2] = whitespaces[elements.indexOf(parent)];
                        if (element.getElement(0) != null && ("ol".equalsIgnoreCase(element.getElement(0).getName()) || "ul".equalsIgnoreCase(element.getElement(0).getName()))) {
                            chunk = "";
                        } else if ("ol".equals(parent.getName())) {
                            int index;
                            int n = index = elements.indexOf(parent);
                            int n2 = orderedListIndex[n] + 1;
                            orderedListIndex[n] = n2;
                            chunk = String.valueOf(whitespaces[index]) + String.valueOf(n2) + ".  ";
                        } else {
                            chunk = String.valueOf(whitespaces[elements.indexOf(parent)]) + "\u2022  ";
                        }
                        crtOffset += chunk.length();
                    } else if (element instanceof AbstractDocument.LeafElement) {
                        HTMLDocument.RunElement runElement;
                        AttributeSet attrSet;
                        if (element instanceof HTMLDocument.RunElement && (attrSet = (AttributeSet)(runElement = (HTMLDocument.RunElement)element).getAttribute(HTML.Tag.A)) != null) {
                            hyperlink = new JRBasePrintHyperlink();
                            hyperlink.setHyperlinkType(HyperlinkTypeEnum.REFERENCE);
                            hyperlink.setHyperlinkReference((String)attrSet.getAttribute(HTML.Attribute.HREF));
                            hyperlink.setLinkTarget((String)attrSet.getAttribute(HTML.Attribute.TARGET));
                        }
                        try {
                            chunk = document.getText(startOffset, endOffset - startOffset);
                        }
                        catch (BadLocationException e) {
                            if (!LOGGER.isDebugEnabled()) break block33;
                            LOGGER.debug("Error converting markup.", (Throwable)e);
                        }
                    }
                }
            }
            ++i2;
        }
        if (chunk != null && !"\n".equals(chunk)) {
            styledText.append(chunk);
            Map<AttributedCharacterIterator.Attribute, Object> styleAttributes = this.getAttributes(element.getAttributes());
            if (hyperlink != null) {
                styleAttributes.put((AttributedCharacterIterator.Attribute)JRTextAttribute.HYPERLINK, hyperlink);
                hyperlink = null;
            }
            if (!styleAttributes.isEmpty()) {
                styledText.addRun(new JRStyledText.Run(styleAttributes, startOffset + crtOffset, endOffset + crtOffset));
            }
        }
        styledText.setGlobalAttributes(new HashMap());
        List runs = styledText.getRuns();
        for (JRStyledText.Run run : runs) {
            if (run.endIndex <= styledText.length()) continue;
            run.endIndex = styledText.length();
        }
        return JRStyledTextParser.getInstance().write(styledText);
    }
}

