/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.batch.BatchAutoConfiguration;
import org.springframework.boot.autoconfigure.data.jpa.JpaRepositoriesAutoConfiguration;
import org.springframework.boot.autoconfigure.ldap.LdapAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.InitBinderDataBinderFactory;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestDataBinderFactory;
import org.squashtest.tm.api.config.SquashPathProperties;
import org.squashtest.tm.web.config.ResourceResolverProperties;

@SpringBootApplication(exclude={JpaRepositoriesAutoConfiguration.class, BatchAutoConfiguration.class, LdapAutoConfiguration.class})
@EnableConfigurationProperties(value={ResourceResolverProperties.class, SquashPathProperties.class})
@EnableWebSecurity
@ImportResource(value={"classpath*:META-INF/spring/dynamicdao-context.xml", "classpath*:META-INF/spring/dynamicmanager-context.xml"})
public class SquashTm {
    private static final Logger LOGGER = LoggerFactory.getLogger(SquashTm.class);

    public static void main(String[] args) {
        new SpringApplication(new Class[]{SquashTm.class}).run(args);
    }

    @Bean
    public WebMvcRegistrations mvcRegistrations() {
        return new WebMvcRegistrations(){

            public RequestMappingHandlerAdapter getRequestMappingHandlerAdapter() {
                return new ExtendedRequestMappingHandlerAdapter();
            }
        };
    }

    private static class ExtendedRequestMappingHandlerAdapter
    extends RequestMappingHandlerAdapter {
        private ExtendedRequestMappingHandlerAdapter() {
        }

        protected InitBinderDataBinderFactory createDataBinderFactory(List<InvocableHandlerMethod> methods) {
            return new ServletRequestDataBinderFactory(methods, this.getWebBindingInitializer()){

                protected ServletRequestDataBinder createBinderInstance(Object target, String name, NativeWebRequest request) throws Exception {
                    ServletRequestDataBinder binder = super.createBinderInstance(target, name, request);
                    String[] fields = binder.getDisallowedFields();
                    ArrayList<String> fieldList = new ArrayList<String>(fields != null ? Arrays.asList(fields) : Collections.emptyList());
                    fieldList.addAll(Arrays.asList("class.*", "Class.*", "*.class.*", "*.Class.*"));
                    binder.setDisallowedFields(fieldList.toArray(new String[0]));
                    return binder;
                }
            };
        }
    }
}

