/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;

public class PluginsPathClasspathExtender
implements SpringApplicationRunListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginsPathClasspathExtender.class);

    public PluginsPathClasspathExtender(SpringApplication app, String[] args) {
    }

    public void starting() {
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
        LOGGER.debug("Context prepared, about to extend classpath");
        ConfigurableEnvironment environment = context.getEnvironment();
        if (environment == null) {
            LOGGER.warn("Environment was not prepared, I don't know where to look for plugins");
            return;
        }
        String pluginsPath = environment.getProperty("squash.path.plugins-path");
        if (pluginsPath == null) {
            LOGGER.warn("Plugin path was not defined, I don't know where to look for plugins");
            return;
        }
        if (!(context instanceof DefaultResourceLoader)) {
            LOGGER.warn("Context is not a DefaultResourceLoader, I don't know how to change the classpath. There will be no plugins");
            return;
        }
        File pluginsFolder = new File(pluginsPath);
        if (!pluginsFolder.exists() || !pluginsFolder.isDirectory()) {
            LOGGER.warn("Plugin path '{}' is not a readable folder. There will be no plugins", (Object)pluginsFolder.getAbsolutePath());
            return;
        }
        LOGGER.info("Enumerating plugins / jars in folder '{}'", (Object)pluginsFolder.getAbsolutePath());
        File[] plugins = pluginsFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (plugins != null) {
            URL[] pluginsUrls = new URL[plugins.length];
            int i = 0;
            while (i < plugins.length) {
                try {
                    URL pluginUrl;
                    pluginsUrls[i] = pluginUrl = plugins[i].toURI().toURL();
                    LOGGER.info("Jar '{}' will be added to classpath", (Object)pluginUrl);
                }
                catch (MalformedURLException e) {
                    LOGGER.warn("Plugin file '{}' could not be converted into a URL", (Object)plugins[i], (Object)e);
                }
                ++i;
            }
            URLClassLoader extendedClassloader = new URLClassLoader(pluginsUrls, context.getClassLoader());
            ((DefaultResourceLoader)context).setClassLoader((ClassLoader)extendedClassloader);
            LOGGER.info("Classpath was extended with the content of plugins folder");
        }
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
        LOGGER.info("loaded");
    }

    public void running(ConfigurableApplicationContext context) {
        LOGGER.info("running");
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }
}

