/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.generic;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.squashtest.tm.service.feature.FeatureManager;

@RestController
public class SquashErrorController
implements ErrorController {
    private static final String PATH = "/error";
    @Value(value="${squashtm.stack.trace.control.panel.visible:true}")
    private Boolean stackTracePanel;
    @Inject
    private FeatureManager featureManager;
    @Inject
    private ErrorAttributes errorAttributes;

    public String error(HttpServletRequest request, HttpServletResponse response, Model model) throws Throwable {
        Map<String, Object> errors = this.getErrorAttributes(request, response);
        model.addAllAttributes(errors);
        model.addAttribute("code", (Object)response.getStatus());
        return "page/error";
    }

    @RequestMapping(value={"/error"})
    public Map<String, Object> errorJson(HttpServletRequest request, HttpServletResponse response, Model model) throws Throwable {
        return this.getErrorAttributes(request, response);
    }

    public String getErrorPath() {
        return PATH;
    }

    private Map<String, Object> getErrorAttributes(HttpServletRequest request, HttpServletResponse response) {
        ServletWebRequest webRequest = new ServletWebRequest(request){};
        Map<String, Object> result = this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.of(EnumSet.allOf(ErrorAttributeOptions.Include.class)));
        if (this.featureManager.isEnabled(FeatureManager.Feature.STACK_TRACE) && Boolean.TRUE.equals(this.stackTracePanel)) {
            response.setHeader("Stack-Trace", "enable");
        } else {
            result = result.entrySet().stream().filter(map -> "status".equals(map.getKey()) || "error".equals(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return result;
    }
}

