/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.config.annotation.web.configurers.LogoutConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.springframework.security.web.csrf.XorCsrfTokenRequestAttributeHandler;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.util.StringUtils;
import org.squashtest.tm.api.security.authentication.ConditionalOnAuthProviderProperty;
import org.squashtest.tm.api.security.authentication.SecurityExemptionEndPoint;
import org.squashtest.tm.service.internal.security.SquashDaoAuthenticationProvider;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManager;
import org.squashtest.tm.service.internal.security.SquashUserDetailsManagerImpl;
import org.squashtest.tm.web.config.AngularAppPageUrls;
import org.squashtest.tm.web.config.CustomAccessDeniedHandler;
import org.squashtest.tm.web.config.CustomRestApiBasicAuthFilter;
import org.squashtest.tm.web.config.DenyInfrastructureAdminFilter;
import org.squashtest.tm.web.config.JwtTokenFilter;
import org.squashtest.tm.web.config.MainEntryPoint;
import org.squashtest.tm.web.security.authentication.SinglePageAppAuthenticationFailureHandler;
import org.squashtest.tm.web.security.authentication.SinglePageAppAuthenticationSuccessHandler;

@Configuration
public class WebSecurityConfig {
    private static final String ALTERNATE_AUTH_PATH = "/auth/**";
    private static final String LOGIN = "/login";
    private static final String LOGOUT = "/logout";
    private static final String ROOT_PATH = "/";
    private static final String CONTROLLERS_ROOT_URL = "/backend";
    private static final String[] ADMIN_ONLY_URLS = new String[]{"/backend/ai-servers/**", "/backend/bugtracker/**", "/backend/bugtrackers/**", "/backend/custom-field-view/**", "/backend/environment-variable-view/**", "/backend/info-list-items/**", "/backend/info-list-view/**", "/backend/info-lists/**", "/backend/profile-view/**", "/backend/project-templates/**", "/backend/projects/**", "/backend/requirement-link-type/**", "/backend/requirements-links/**", "/backend/scm-server-view/**", "/backend/scm-servers/**", "/backend/system/**", "/backend/team-view/**", "/backend/teams/**", "/backend/test-automation-servers/**", "/backend/user-view/**", "/backend/users/**", "/backend/users/**"};
    @Value(value="${squash.security.basic.token-charset}")
    private static String basicAuthCharset = "ISO-8859-1";

    @Configuration
    public static class ActuatorWebSecurityConfigurationAdapter {
        @Value(value="${squash.cloud-mode-enabled:false}")
        private boolean needsInfrastructureAdmin;

        @Bean
        @Order(value=15)
        protected SecurityFilterChain actuatorFilterChain(HttpSecurity http, JwtTokenFilter actuatorJwtTokenFilter, CustomAccessDeniedHandler customAccessDeniedHandler) throws Exception {
            String actuatorAccessRole = this.needsInfrastructureAdmin ? "ROLE_INFRASTRUCTURE_ADMIN" : "ROLE_ADMIN";
            http.csrf(AbstractHttpConfigurer::disable).securityMatcher(new String[]{"/actuator/**"}).authorizeHttpRequests(authz -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).hasAuthority(actuatorAccessRole);
            }).exceptionHandling(e -> {
                ExceptionHandlingConfigurer exceptionHandlingConfigurer = e.accessDeniedHandler((AccessDeniedHandler)customAccessDeniedHandler);
            }).httpBasic(httpBasic -> {
                AbstractHttpConfigurer abstractHttpConfigurer = httpBasic.withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(basicAuthCharset));
            });
            http.addFilterBefore((Filter)actuatorJwtTokenFilter, UsernamePasswordAuthenticationFilter.class);
            return (SecurityFilterChain)http.build();
        }
    }

    @Configuration
    public static class ApiWebSecurityConfigurationAdapter {
        @Bean
        CustomRestApiBasicAuthFilter customRestApiBasicAuthFilter() {
            return new CustomRestApiBasicAuthFilter();
        }

        @Bean
        @Order(value=20)
        protected SecurityFilterChain apiFilterChain(HttpSecurity http, JwtTokenFilter apiJwtTokenFilter, CustomAccessDeniedHandler customAccessDeniedHandler, DenyInfrastructureAdminFilter denyInfrastructureAdminFilter) throws Exception {
            http.csrf(AbstractHttpConfigurer::disable).securityMatcher(new String[]{"/api/**"}).authorizeHttpRequests(authz -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).authenticated();
            }).httpBasic(httpBasic -> {
                HttpBasicConfigurer httpBasicConfigurer = ((HttpBasicConfigurer)httpBasic.withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(basicAuthCharset))).realmName("squash-api").authenticationEntryPoint((request, response, authException) -> {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"squah-api\"");
                    response.addHeader("Content-Type", "application/json");
                    response.sendError(401, authException.getMessage() + ". You may authenticate using 1/ basic authentication or 2/ fetching a cookie JSESSIONID from /login");
                });
            }).exceptionHandling(e -> {
                ExceptionHandlingConfigurer exceptionHandlingConfigurer = e.accessDeniedHandler((AccessDeniedHandler)customAccessDeniedHandler);
            }).logout(logout -> {
                LogoutConfigurer logoutConfigurer = logout.logoutUrl(WebSecurityConfig.LOGOUT).invalidateHttpSession(true).logoutSuccessUrl(WebSecurityConfig.ROOT_PATH).permitAll();
            });
            http.addFilterBefore((Filter)this.customRestApiBasicAuthFilter(), BasicAuthenticationFilter.class);
            http.addFilterBefore((Filter)apiJwtTokenFilter, UsernamePasswordAuthenticationFilter.class);
            http.addFilterAfter((Filter)denyInfrastructureAdminFilter, AuthorizationFilter.class);
            return (SecurityFilterChain)http.build();
        }
    }

    private record BasicAuthCharsetConfigurer(String charset) implements ObjectPostProcessor<BasicAuthenticationFilter>
    {
        public <O extends BasicAuthenticationFilter> O postProcess(O object) {
            object.setCredentialsCharset(this.charset);
            return object;
        }
    }

    @Configuration
    public static class SquashTAWebSecurityConfigurationAdapter {
        @Bean
        @Order(value=10)
        protected SecurityFilterChain squashTaFilterChain(HttpSecurity http) throws Exception {
            http.csrf(AbstractHttpConfigurer::disable).securityMatcher(new String[]{"/automated-executions/**"}).authorizeHttpRequests(authz -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.anyRequest()).hasRole("TA_API_CLIENT");
            }).httpBasic(httpBasic -> {
                AbstractHttpConfigurer abstractHttpConfigurer = httpBasic.withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(basicAuthCharset));
            });
            return (SecurityFilterChain)http.build();
        }
    }

    @Configuration
    public static class StandardWebSecurityConfigurerAdapter {
        private static final List<String> DEFAULT_IGNORE_AUTH_URLS = Arrays.asList("/", "/login", "/auth/**", "/logout", "/logged-out");
        @Autowired(required=false)
        private Collection<SecurityExemptionEndPoint> securityExemptionEndPoints = Collections.emptyList();
        @Value(value="${squash.security.filter.debug.enabled:false}")
        private boolean debugSecurityFilter;
        @Value(value="${squash.security.preferred-auth-url:/login}")
        private String entryPointUrl = "/login";
        @Value(value="${squash.security.ignored:/scripts/**}")
        private String[] secIngored;
        @Autowired
        private Environment environment;
        @Value(value="${authentication.provider:internal}")
        private String authenticationProvider;
        @Inject
        @Named(value="userDetailsManager.caseSensitive")
        private SquashUserDetailsManager caseSensitive;
        @Inject
        @Named(value="userDetailsManager.caseInsensitive")
        private SquashUserDetailsManager caseInsensitive;

        @Bean
        public SessionRegistry sessionRegistry() {
            return new SessionRegistryImpl();
        }

        @Bean
        public HttpSessionEventPublisher httpSessionEventPublisher() {
            return new HttpSessionEventPublisher();
        }

        @Bean
        public WebSecurityCustomizer standardWebSecurityCustomizer() {
            return web -> {
                Object object = web.debug(this.debugSecurityFilter).ignoring().requestMatchers(this.secIngored);
            };
        }

        @Bean
        @ConditionalOnAuthProviderProperty(value="internal", matchIfMissing=true)
        public DaoAuthenticationProvider internalDaoAuthenticationProvider(SquashUserDetailsManager squashUserDetailsManager, PasswordEncoder passwordEncoder) {
            SquashDaoAuthenticationProvider provider = new SquashDaoAuthenticationProvider();
            provider.setUserDetailsService((UserDetailsService)squashUserDetailsManager);
            provider.setPasswordEncoder(passwordEncoder);
            return provider;
        }

        @Bean
        @Order(value=30)
        protected SecurityFilterChain standardFilterChain(HttpSecurity http, SquashUserDetailsManager squashUserDetailsManager, PasswordEncoder passwordEncoder) throws Exception {
            this.configureInternalAuthenticationProvider(http, squashUserDetailsManager, passwordEncoder);
            this.configureCsrf(http).headers(headers -> {
                HeadersConfigurer headersConfigurer = headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin);
            }).httpBasic(Customizer.withDefaults()).authorizeHttpRequests(authz -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authz.requestMatchers(this.gatherIgnoringAuthUrlPatterns())).permitAll().requestMatchers(new String[]{"/backend/login", "/backend/logout", "/backend/login-page", "/backend/version", "/index.html", WebSecurityConfig.LOGIN, "/favicon.ico"})).permitAll().requestMatchers(new String[]{"/plugin/**", "/index"})).permitAll().requestMatchers(AngularAppPageUrls.getAllUrlsPatterns())).permitAll().requestMatchers(new String[]{"/*.js", "/**.js", "/**.json", "/*.js.map", "/**.js.map", "/resources/**", "/*.css", "/*.ts", "/*.ttf", "/assets/**"})).permitAll().requestMatchers(ADMIN_ONLY_URLS)).hasAuthority("ROLE_ADMIN").anyRequest()).access((auth, context) -> this.checkAccess((Authentication)auth.get()));
            }).exceptionHandling(exceptionHandling -> {
                ExceptionHandlingConfigurer exceptionHandlingConfigurer = exceptionHandling.authenticationEntryPoint(this.mainEntryPoint());
            }).formLogin(formLogin -> {
                AbstractAuthenticationFilterConfigurer abstractAuthenticationFilterConfigurer = ((FormLoginConfigurer)((FormLoginConfigurer)formLogin.loginProcessingUrl("/backend/login")).successHandler((AuthenticationSuccessHandler)this.singlePageAppAuthenticationSuccessHandler())).failureHandler((AuthenticationFailureHandler)this.singlePageAppAuthenticationFailureHandler());
            }).sessionManagement(session -> {
                SessionManagementConfigurer.ConcurrencyControlConfigurer concurrencyControlConfigurer = session.maximumSessions(-1).sessionRegistry(this.sessionRegistry());
            });
            DefaultSecurityFilterChain filterChain = (DefaultSecurityFilterChain)http.build();
            AuthenticationManager authenticationManager = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
            ((SquashUserDetailsManagerImpl)this.caseSensitive).setAuthenticationManager(authenticationManager);
            ((SquashUserDetailsManagerImpl)this.caseInsensitive).setAuthenticationManager(authenticationManager);
            return filterChain;
        }

        private AuthorizationDecision checkAccess(Authentication authentication) {
            AuthorizationDecision authDecision = AuthenticatedAuthorizationManager.authenticated().check(() -> authentication, null);
            if (authDecision.isGranted()) {
                boolean hasNotForbiddenRole = authentication.getAuthorities().stream().noneMatch(grantedAuthority -> "ROLE_INFRASTRUCTURE_ADMIN".equals(grantedAuthority.getAuthority()) || "ROLE_TA_API_CLIENT".equals(grantedAuthority.getAuthority()));
                return new AuthorizationDecision(hasNotForbiddenRole);
            }
            return authDecision;
        }

        private void configureInternalAuthenticationProvider(HttpSecurity http, SquashUserDetailsManager squashUserDetailsManager, PasswordEncoder passwordEncoder) {
            if (this.authenticationProvider.contains("internal")) {
                http.authenticationProvider((AuthenticationProvider)this.internalDaoAuthenticationProvider(squashUserDetailsManager, passwordEncoder));
            }
        }

        private HttpSecurity configureCsrf(HttpSecurity http) throws Exception {
            if (this.isTestProfileActive()) {
                http.csrf(AbstractHttpConfigurer::disable);
            } else {
                http.csrf(csrf -> {
                    CsrfConfigurer csrfConfigurer = csrf.csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).csrfTokenRequestHandler((CsrfTokenRequestHandler)new SpaCsrfTokenRequestHandler()).ignoringRequestMatchers(this.gatherIgnoringCsrfUrlPatterns());
                });
            }
            return http;
        }

        private boolean isTestProfileActive() {
            return Arrays.asList(this.environment.getActiveProfiles()).contains("test");
        }

        @Bean
        public SinglePageAppAuthenticationSuccessHandler singlePageAppAuthenticationSuccessHandler() {
            return new SinglePageAppAuthenticationSuccessHandler();
        }

        @Bean
        public SinglePageAppAuthenticationFailureHandler singlePageAppAuthenticationFailureHandler() {
            return new SinglePageAppAuthenticationFailureHandler();
        }

        @Bean
        public AuthenticationEntryPoint mainEntryPoint() {
            return new MainEntryPoint(this.entryPointUrl);
        }

        private String[] gatherIgnoringCsrfUrlPatterns() {
            ArrayList<String> result = new ArrayList<String>(Collections.singletonList(WebSecurityConfig.ALTERNATE_AUTH_PATH));
            for (SecurityExemptionEndPoint endPoint : this.securityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreCsrfUrlPatterns());
            }
            return result.toArray(new String[0]);
        }

        @Bean
        public HttpFirewall customHttpFirewall() {
            StrictHttpFirewall firewall = new StrictHttpFirewall();
            firewall.setAllowSemicolon(true);
            firewall.setAllowUrlEncodedPercent(true);
            return firewall;
        }

        private String[] gatherIgnoringAuthUrlPatterns() {
            ArrayList<String> result = new ArrayList<String>(DEFAULT_IGNORE_AUTH_URLS);
            for (SecurityExemptionEndPoint endPoint : this.securityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreAuthUrlPatterns());
            }
            return result.toArray(new String[0]);
        }

        static final class SpaCsrfTokenRequestHandler
        implements CsrfTokenRequestHandler {
            private final CsrfTokenRequestHandler plain = new CsrfTokenRequestAttributeHandler();
            private final CsrfTokenRequestHandler xor = new XorCsrfTokenRequestAttributeHandler();

            SpaCsrfTokenRequestHandler() {
            }

            public void handle(HttpServletRequest request, HttpServletResponse response, Supplier<CsrfToken> csrfToken) {
                this.xor.handle(request, response, csrfToken);
                csrfToken.get();
            }

            public String resolveCsrfTokenValue(HttpServletRequest request, CsrfToken csrfToken) {
                String headerValue = request.getHeader(csrfToken.getHeaderName());
                return (StringUtils.hasText((String)headerValue) ? this.plain : this.xor).resolveCsrfTokenValue(request, csrfToken);
            }
        }
    }
}

