/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.report;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.ServletContextAware;
import org.squashtest.tm.annotation.WebComponent;
import org.squashtest.tm.api.report.BasicDirectDownloadableReport;
import org.squashtest.tm.api.report.Report;
import org.squashtest.tm.api.report.ReportPlugin;
import org.squashtest.tm.api.report.ReportView;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

@WebComponent
public class ReportViewServletContextInitializer
implements ServletContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportViewServletContextInitializer.class);
    private ServletContext servletContext;
    @Autowired(required=false)
    private Collection<ReportPlugin> reportPlugins = Collections.emptyList();

    @PostConstruct
    public synchronized void registerViews() {
        for (ReportPlugin plugin : this.reportPlugins) {
            if (plugin == null) continue;
            this.apply(RegistrationAction.BIND_CONTEXT, plugin);
        }
    }

    private void apply(RegistrationAction action, ReportPlugin plugin) {
        Report[] reports;
        Report[] reportArray = reports = plugin.getReports();
        int n = reports.length;
        int n2 = 0;
        while (n2 < n) {
            Report report = reportArray[n2];
            this.apply(action, report);
            ++n2;
        }
    }

    private void apply(RegistrationAction action, Report report) {
        boolean isDirectDownLoadableReport = report instanceof BasicDirectDownloadableReport;
        if (!isDirectDownLoadableReport) {
            int viewIndex = 0;
            while (viewIndex < report.getViews().length) {
                ReportView view = report.getViews()[viewIndex];
                action.apply(this.servletContext, view);
                ++viewIndex;
            }
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private static enum RegistrationAction {
        BIND_CONTEXT{

            @Override
            public void apply(ServletContext servletContext, ReportView view) {
                if (view.getSpringView() instanceof ServletContextAware) {
                    ServletContextAware springView = (ServletContextAware)view.getSpringView();
                    springView.setServletContext(servletContext);
                    LOGGER.info("Bound ServletContext to view [{}]", new Object[]{view});
                }
            }
        };


        public abstract void apply(ServletContext var1, ReportView var2);
    }
}

