/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.manager.synchronisation;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.stereotype.Component;
import org.squashtest.tm.api.wizard.SynchronisationPlugin;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.web.backend.manager.synchronisation.SynchronisationPluginManager;

@Component
public class SynchronisationPluginManagerImpl
implements SynchronisationPluginManager,
ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronisationPluginManagerImpl.class);
    public static final int DEFAULT_DELAY = 300;
    public static final int MIN_DELAY = 5;
    @Autowired(required=false)
    private Collection<SynchronisationPlugin> plugins = Collections.emptyList();
    @Inject
    @Named(value="squashtest.tm.service.ThreadPoolTaskScheduler")
    private TaskScheduler taskScheduler;
    @Inject
    private Environment environment;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.scheduleSynchronisations();
    }

    private void scheduleSynchronisations() {
        if (this.synchronisationsAreEnabled()) {
            Duration delay = this.getDelay();
            for (SynchronisationPlugin plugin : this.plugins) {
                LOGGER.info("Registering synchronisation plugin {} as {}", new Object[]{plugin, plugin.getName()});
                this.taskScheduler.scheduleWithFixedDelay(plugin.performSynchronisation(), delay);
            }
        } else {
            LOGGER.info("Synchronisations were disabled for this instance.", new Object[0]);
        }
    }

    private boolean synchronisationsAreEnabled() {
        String property = this.environment.getProperty("squash.external.synchronisation.enabled");
        return !StringUtils.equalsIgnoreCase((CharSequence)Boolean.FALSE.toString(), (CharSequence)property);
    }

    private Duration getDelay() {
        String property = this.environment.getProperty("squash.external.synchronisation.delay");
        int delay = 300;
        if (StringUtils.isNotBlank((CharSequence)property)) {
            try {
                delay = Integer.parseInt(property);
                delay = Math.max(delay, 5);
                LOGGER.info("Found the property 'squash.external.synchronisation.delay'. Delay between sync will be  : " + delay + " seconds.", new Object[0]);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Impossible to parse the property 'squash.external.synchronisation.delay' as a number. Please provide a valid synchronisation delay.", new Object[0]);
                throw e;
            }
        }
        return Duration.ofSeconds(delay);
    }

    @Override
    public Collection<SynchronisationPlugin> findAll() {
        return this.plugins;
    }
}

