/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.interceptor;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.core.foundation.lang.Assert;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;

public class ExcludeRequestInterceptorWrapper
implements HandlerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcludeRequestInterceptorWrapper.class);
    private final HandlerInterceptor delegate;
    private Collection<String> excludedExtensions = Collections.emptyList();

    public ExcludeRequestInterceptorWrapper(HandlerInterceptor delegate) {
        Assert.parameterNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.proceedWith(request)) {
            return this.delegate.preHandle(request, response, handler);
        }
        return true;
    }

    private boolean proceedWith(HttpServletRequest request) {
        return !this.matchesExcludedExtensions(request);
    }

    private boolean matchesExcludedExtensions(HttpServletRequest request) {
        if (this.excludedExtensions.isEmpty()) {
            return false;
        }
        String pathInfo = request.getServletPath() + StringUtils.defaultString((String)request.getPathInfo());
        int dotPos = pathInfo.lastIndexOf(46);
        if (dotPos > -1) {
            String ext = pathInfo.substring(dotPos + 1).toLowerCase().trim();
            boolean excluded = this.excludedExtensions.contains(ext);
            if (excluded) {
                LOGGER.trace("Request {} matches excluded extensions", new Object[]{pathInfo});
            }
            return excluded;
        }
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        this.delegate.postHandle(request, response, handler, modelAndView);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.delegate.afterCompletion(request, response, handler, ex);
    }

    public void setExcludedExtensions(String[] excludedExtensions) {
        Assert.parameterNotNull((Object)excludedExtensions, (String)"excludedExtensions");
        LOGGER.debug("Excluded extensions : {} ({} excluded extensions)", new Object[]{excludedExtensions, excludedExtensions.length});
        Collection nonNullExtensions = CollectionUtils.select(Arrays.asList(excludedExtensions), (Predicate)NotNullPredicate.getInstance());
        this.excludedExtensions = CollectionUtils.collect((Collection)nonNullExtensions, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return ((String)input).trim().toLowerCase();
            }
        });
    }
}

