/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.web.backend.helper.JsonMarshallerException;

public final class JsonHelper {
    private static JsonHelper INSTANCE;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public static String serialize(Object value) throws JsonMarshallerException {
        JsonHelper.lazyInitializeSingleton();
        try {
            return JsonHelper.INSTANCE.objectMapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new JsonMarshallerException(e);
        }
    }

    public static Map<String, Object> deserialize(String json) throws IOException {
        JsonHelper.lazyInitializeSingleton();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (Map)JsonHelper.INSTANCE.objectMapper.readValue(HtmlUtils.htmlUnescape((String)json), (TypeReference)typeRef);
    }

    public static String marshall(Object value) throws JsonMarshallerException {
        return JsonHelper.serialize(value);
    }

    public static Map<String, Object> unmarshall(String json) throws IOException {
        return JsonHelper.deserialize(json);
    }

    private static void lazyInitializeSingleton() {
        if (INSTANCE == null) {
            INSTANCE = new JsonHelper();
        }
    }
}

