/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.AbstractView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.exception.testcase.ScriptParsingException;
import org.squashtest.tm.web.backend.exceptionresolver.ActionValidationErrorModel;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

@Deprecated
public class HandlerScriptParsingExceptionResolver
extends AbstractHandlerExceptionResolver {
    @Inject
    private MessageSource messageSource;

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.exceptionIsHandled(ex)) {
            return this.handleException(request, response, ex);
        }
        return null;
    }

    private ModelAndView handleException(HttpServletRequest request, HttpServletResponse response, Exception ex) {
        ScriptParsingException parsingException = (ScriptParsingException)ex;
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.APPLICATION_JSON) || ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.ANYTHING)) {
            return this.formatJsonResponse(response, parsingException, request.getLocale());
        }
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.TEXT_PLAIN)) {
            return this.formatPlainTextResponse(response, parsingException, request.getLocale());
        }
        return null;
    }

    private ModelAndView formatPlainTextResponse(HttpServletResponse response, ScriptParsingException parsingException, Locale locale) {
        response.setStatus(412);
        String exception = parsingException.getClass().getSimpleName();
        String message = this.getLocalizedMessage(locale, parsingException);
        String error = exception + ":" + message;
        PlainTextView view = new PlainTextView();
        return new ModelAndView((View)view, "actionValidationError", (Object)error);
    }

    private ModelAndView formatJsonResponse(HttpServletResponse response, ScriptParsingException parsingException, Locale locale) {
        response.setStatus(412);
        String exception = parsingException.getClass().getSimpleName();
        String message = this.getLocalizedMessage(locale, parsingException);
        ActionValidationErrorModel error = new ActionValidationErrorModel(exception, message);
        return new ModelAndView((View)new MappingJackson2JsonView(), "actionValidationError", (Object)error);
    }

    private String getLocalizedMessage(Locale locale, ScriptParsingException parsingException) {
        Object message = this.messageSource.getMessage("squashtm.action.exception.testcase.scripted.parsing", null, locale);
        message = (String)message + "\n\n" + parsingException.getCause().getMessage();
        return ((String)message).replace("\n", "<br/>");
    }

    private boolean exceptionIsHandled(Exception ex) {
        return ScriptParsingException.class.isAssignableFrom(ex.getClass());
    }

    private static class PlainTextView
    extends AbstractView {
        private PlainTextView() {
        }

        protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
            for (Object obj : model.values()) {
                response.getOutputStream().write(obj.toString().getBytes());
                response.getOutputStream().write(10);
            }
        }
    }
}

