/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.exceptionresolver;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.owasp.esapi.errors.IntrusionException;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.web.backend.exceptionresolver.ExceptionResolverUtils;
import org.squashtest.tm.web.backend.exceptionresolver.HandlerSimpleExceptionResolver;
import org.squashtest.tm.web.backend.exceptionresolver.MimeType;

@Component
public class HandlerIntrusionExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerIntrusionExceptionResolver.class);

    @ExceptionHandler(value={IntrusionException.class})
    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (!(ex instanceof IntrusionException)) {
            return null;
        }
        IntrusionException intrusionException = (IntrusionException)ex;
        LOGGER.error(intrusionException.getLogMessage(), (Throwable)ex);
        response.setStatus(403);
        String message = intrusionException.getUserMessage();
        if (message.isBlank()) {
            message = "An intrusion was detected";
        }
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.APPLICATION_JSON)) {
            return new ModelAndView((View)new MappingJackson2JsonView(), "intrusionException", (Object)message);
        }
        if (ExceptionResolverUtils.clientAcceptsMIME(request, MimeType.TEXT_PLAIN)) {
            return new ModelAndView((View)new HandlerSimpleExceptionResolver.PlainTextView(), "simpleError", (Object)message);
        }
        return null;
    }
}

