/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testplan;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.testplan.SprintTestPlanDisplayService;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.testplanitem.SprintTestPlanItemManager;

@RestController
@RequestMapping(value={"/backend/sprint-req-version"})
public class SprintTestPlanController {
    private final SprintTestPlanDisplayService sprintTestPlanDisplayService;
    private final SprintTestPlanItemManager sprintTestPlanItemManager;

    public SprintTestPlanController(SprintTestPlanDisplayService sprintTestPlanDisplayService, SprintTestPlanItemManager sprintTestPlanItemManager) {
        this.sprintTestPlanDisplayService = sprintTestPlanDisplayService;
        this.sprintTestPlanItemManager = sprintTestPlanItemManager;
    }

    @PostMapping(value={"/{sprintReqVersionId}/test-plan"})
    GridResponse findSprintTestPlan(@PathVariable Long sprintReqVersionId, @RequestBody GridRequest gridRequest) {
        return this.sprintTestPlanDisplayService.findSprintReqVersionTestPlan(sprintReqVersionId, gridRequest);
    }

    @DeleteMapping(value={"/{sprintReqVersionId}/test-plan-items/{testPlanItemIds}"})
    public void deleteItems(@PathVariable Long sprintReqVersionId, @PathVariable List<Long> testPlanItemIds) {
        this.sprintTestPlanItemManager.deleteSprintReqVersionTestPlanItems(sprintReqVersionId, testPlanItemIds);
    }
}

