/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase.steps;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.testcase.ActionTestStep;
import org.squashtest.tm.domain.testcase.KeywordTestStep;
import org.squashtest.tm.domain.testcase.ParameterAssignationMode;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.testcase.AbstractTestStepDto;
import org.squashtest.tm.service.internal.display.dto.testcase.AddTestStepOperationReport;
import org.squashtest.tm.service.internal.display.dto.testcase.PasteTestStepOperationReport;
import org.squashtest.tm.service.internal.display.testcase.parameter.TestCaseParameterOperationReport;
import org.squashtest.tm.service.testcase.CallStepManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;
import org.squashtest.tm.web.backend.controller.testcase.steps.ActionStepFormModel;
import org.squashtest.tm.web.backend.controller.testcase.steps.KeywordTestStepModel;
import org.squashtest.tm.web.i18n.InternationalizationHelper;

@RestController
@RequestMapping(value={"/backend/test-cases/{testCaseId}/steps"})
public class TestCaseTestStepsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestCaseTestStepsController.class);
    private static final String TEST_CASE = "test case ";
    private final CallStepManagerService callStepManager;
    private final TestCaseModificationService testCaseModificationService;
    private final TestCaseDisplayService testCaseDisplayService;
    private final InternationalizationHelper internationalizationHelper;

    public TestCaseTestStepsController(CallStepManagerService callStepManager, TestCaseModificationService testCaseModificationService, TestCaseDisplayService testCaseDisplayService, InternationalizationHelper internationalizationHelper) {
        this.callStepManager = callStepManager;
        this.testCaseModificationService = testCaseModificationService;
        this.testCaseDisplayService = testCaseDisplayService;
        this.internationalizationHelper = internationalizationHelper;
    }

    @PostMapping(value={"/add"}, consumes={"application/json"})
    public AddTestStepOperationReport addActionTestStep(@RequestBody ActionStepFormModel stepModel, @PathVariable long testCaseId) {
        ActionTestStep step = stepModel.getActionTestStep();
        Map<Long, RawValue> customFieldValues = stepModel.getCufs();
        int index = stepModel.getIndex();
        ActionTestStep actionTestStep = index != 0 ? this.testCaseModificationService.addActionTestStep(testCaseId, step, customFieldValues, index) : this.testCaseModificationService.addActionTestStep(testCaseId, step, customFieldValues);
        LOGGER.trace(TEST_CASE + testCaseId + ": step added, action : " + step.getAction() + ", expected result : " + step.getExpectedResult(), new Object[0]);
        AbstractTestStepDto dto = this.testCaseModificationService.findTestStep(actionTestStep.getId());
        TestCaseParameterOperationReport testCaseParameterOperationReport = this.testCaseDisplayService.findParametersDataByTestStepId(actionTestStep.getId());
        return new AddTestStepOperationReport(dto, testCaseParameterOperationReport);
    }

    @PostMapping(value={"/add-keyword-test-step"})
    public AddTestStepOperationReport addKeywordTestStep(@RequestBody KeywordTestStepModel keywordTestStepDto, @PathVariable long testCaseId) throws BindException {
        this.validateDto(keywordTestStepDto);
        String keyword = keywordTestStepDto.getKeyword();
        String actionWord = keywordTestStepDto.getActionWord();
        int index = keywordTestStepDto.getIndex();
        Long newKeywordStepId = keywordTestStepDto.getActionWordId() != null ? this.addKeywordTestStepWithActionWordId(keywordTestStepDto, testCaseId) : (index != 0 ? this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord, index).getId() : this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord).getId());
        AbstractTestStepDto dto = this.testCaseModificationService.findTestStep(newKeywordStepId);
        TestCaseParameterOperationReport testCaseParameterOperationReport = this.testCaseDisplayService.findParametersDataByTestStepId(newKeywordStepId);
        return new AddTestStepOperationReport(dto, testCaseParameterOperationReport);
    }

    public Long addKeywordTestStepWithActionWordId(KeywordTestStepModel keywordTestStepDto, long testCaseId) throws BindException {
        this.validateDto(keywordTestStepDto);
        String keyword = keywordTestStepDto.getKeyword();
        String actionWord = keywordTestStepDto.getActionWord();
        int index = keywordTestStepDto.getIndex();
        long actionWordId = keywordTestStepDto.getActionWordId();
        KeywordTestStep step = this.testCaseModificationService.addKeywordTestStep(testCaseId, keyword, actionWord, Long.valueOf(actionWordId), index);
        return step.getId();
    }

    private void validateDto(KeywordTestStepModel keywordTestStepDto) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)keywordTestStepDto, "add-keyword-test-step");
        KeywordTestStepModel.KeywordTestStepModelValidator validator = new KeywordTestStepModel.KeywordTestStepModelValidator(this.internationalizationHelper);
        validator.validate(keywordTestStepDto, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
    }

    @PostMapping(value={"/compare-keywords-projects"}, consumes={"application/json"})
    public ResponseEntity<Boolean> compareKeywordProjectsIds(@RequestBody CopyStepModel copyStepModel, @PathVariable long testCaseId) {
        List<Long> copiedTestStepIds = copyStepModel.getCopiedStepIds();
        List copiedTestStepsProjectsIds = this.testCaseModificationService.fetchProjectsIdsByTestStepsIds(copiedTestStepIds);
        Long targetProjectId = this.testCaseModificationService.fetchTargetProjectId(Long.valueOf(testCaseId));
        return ResponseEntity.ok((Object)this.testCaseModificationService.areCopiedTestStepsProjectsIdsEqualToTargetProjectId(copiedTestStepsProjectsIds, targetProjectId));
    }

    @PostMapping(value={"/paste"}, consumes={"application/json"})
    public PasteTestStepOperationReport pasteSteps(@RequestBody CopyStepModel copyStepModel, @PathVariable long testCaseId) {
        List<Long> copiedStepIds = copyStepModel.getCopiedStepIds();
        this.callStepManager.checkForCyclicStepCallBeforePaste(testCaseId, copiedStepIds);
        PasteTestStepOperationReport pasteTestStepOperationReport = copyStepModel.targetTestStepId != null ? this.testCaseModificationService.pasteCopiedTestSteps(testCaseId, copyStepModel.getTargetTestStepId().longValue(), copiedStepIds, copyStepModel.isAssignedToTargetProject()) : this.testCaseModificationService.pasteCopiedTestStepToLastIndex(testCaseId, copiedStepIds, copyStepModel.isAssignedToTargetProject());
        pasteTestStepOperationReport.setOperationReport(this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId)));
        return pasteTestStepOperationReport;
    }

    @PostMapping(value={"/move"})
    public void changeStepsIndex(@PathVariable long testCaseId, @RequestBody MoveStepModel moveStepModel) {
        this.testCaseModificationService.changeTestStepsPosition(testCaseId, moveStepModel.newIndex.intValue(), moveStepModel.movedStepIds);
    }

    @DeleteMapping(value={"/{stepIds}"})
    public TestCaseParameterOperationReport deleteSteps(@PathVariable(value="stepIds") List<Long> stepIds, @PathVariable long testCaseId) {
        this.testCaseModificationService.removeListOfSteps(testCaseId, stepIds);
        return this.testCaseDisplayService.findParametersData(Long.valueOf(testCaseId));
    }

    @PostMapping(value={"/call-test-case"})
    public PasteTestStepOperationReport addCallTestStep(@PathVariable(value="testCaseId") long callingTestCaseId, @RequestBody CallTestCaseModel callTestCaseModel) {
        return this.callStepManager.addCallTestSteps(callingTestCaseId, callTestCaseModel.calledTestCaseIds, callTestCaseModel.index);
    }

    @PostMapping(value={"{stepId}/parameter-assignation-mode"})
    public TestCaseParameterOperationReport changeParameterAssignationMode(@PathVariable(value="testCaseId") Long testCaseId, @PathVariable(value="stepId") Long stepId, @RequestBody ParameterAssignationModel model) {
        this.callStepManager.setParameterAssignationMode(stepId.longValue(), ParameterAssignationMode.valueOf((String)model.getMode()), model.getDatasetId());
        return this.testCaseDisplayService.findParametersData(testCaseId);
    }

    static class CallTestCaseModel {
        private List<Long> calledTestCaseIds = new ArrayList<Long>();
        private Integer index;

        CallTestCaseModel() {
        }

        public List<Long> getCalledTestCaseIds() {
            return this.calledTestCaseIds;
        }

        public void setCalledTestCaseIds(List<Long> calledTestCaseIds) {
            this.calledTestCaseIds = calledTestCaseIds;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }
    }

    static class CopyStepModel {
        private List<Long> copiedStepIds = new ArrayList<Long>();
        private Long targetTestStepId;
        @JsonProperty
        private Boolean isAssignedToTargetProject;

        CopyStepModel() {
        }

        public List<Long> getCopiedStepIds() {
            return this.copiedStepIds;
        }

        public void setCopiedStepIds(List<Long> copiedStepIds) {
            this.copiedStepIds = copiedStepIds;
        }

        public Long getTargetTestStepId() {
            return this.targetTestStepId;
        }

        public void setTargetTestStepId(Long targetTestStepId) {
            this.targetTestStepId = targetTestStepId;
        }

        public boolean isAssignedToTargetProject() {
            return Optional.ofNullable(this.isAssignedToTargetProject).orElse(false);
        }
    }

    static class MoveStepModel {
        private List<Long> movedStepIds = new ArrayList<Long>();
        private Integer newIndex;

        MoveStepModel() {
        }

        public List<Long> getMovedStepIds() {
            return this.movedStepIds;
        }

        public void setMovedStepIds(List<Long> movedStepIds) {
            this.movedStepIds = movedStepIds;
        }

        public Integer getNewIndex() {
            return this.newIndex;
        }

        public void setNewIndex(Integer newIndex) {
            this.newIndex = newIndex;
        }
    }

    static class ParameterAssignationModel {
        private String mode;
        private Long datasetId;

        ParameterAssignationModel() {
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public Long getDatasetId() {
            return this.datasetId;
        }

        public void setDatasetId(Long datasetId) {
            this.datasetId = datasetId;
        }
    }
}

