/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.NodeReferences;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseMultiSelectionDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.backend.controller.form.model.NodeList;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/test-case-workspace-multi-view"})
public class TestCaseMultiViewController {
    private final TestCaseDisplayService testCaseDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public TestCaseMultiViewController(TestCaseDisplayService testCaseDisplayService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, TestCaseLibraryNavigationService testCaseLibraryNavigationService) {
        this.testCaseDisplayService = testCaseDisplayService;
        this.builderProvider = builderProvider;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
    }

    @PostMapping
    public TestCaseMultiSelectionDto getTestCaseMultiView(@RequestBody NodeList statisticRequest, Locale locale) {
        NodeReferences nodeReferences = statisticRequest.asNodeReferences();
        TestCaseMultiSelectionDto testCaseMultiSelectionDto = this.testCaseDisplayService.getTestCaseMultiView();
        if (testCaseMultiSelectionDto.isShouldShowFavoriteDashboard()) {
            if (testCaseMultiSelectionDto.isCanShowFavoriteDashboard()) {
                List<String> references = statisticRequest.getReferences();
                List<EntityReference> entityReferences = references.stream().map(EntityReference::fromNodeId).toList();
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(testCaseMultiSelectionDto.getFavoriteDashboardId());
                CustomReportDashboardDto dashboardDto = new CustomReportDashboardDto(Workspace.TEST_CASE, entityReferences);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(testCaseMultiSelectionDto.getFavoriteDashboardId(), dashboard, locale, dashboardDto);
                testCaseMultiSelectionDto.setDashboard(jsonDashboard);
            }
        } else {
            Set libraryIds = nodeReferences.extractLibraryIds();
            Set testCaseNodeIds = nodeReferences.extractNonLibraryIds();
            testCaseMultiSelectionDto.setStatistics(this.testCaseLibraryNavigationService.getStatisticsForSelection((Collection)libraryIds, (Collection)testCaseNodeIds));
        }
        return testCaseMultiSelectionDto;
    }
}

