/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import jakarta.inject.Named;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.testcase.TestCaseFolder;
import org.squashtest.tm.service.library.FolderModificationService;

@RestController
@RequestMapping(value={"/backend/test-case-folder"})
public class TestCaseFolderViewModificationController {
    private FolderModificationService<TestCaseFolder> folderModificationService;

    public TestCaseFolderViewModificationController(@Named(value="squashtest.tm.service.TestCaseFolderModificationService") FolderModificationService<TestCaseFolder> folderModificationService) {
        this.folderModificationService = folderModificationService;
    }

    @PostMapping(value={"/{testCaseFolderId}/name"})
    public void changeName(@PathVariable long testCaseFolderId, @RequestBody TestCaseFolderPatch testCaseFolderPatch) {
        this.folderModificationService.renameFolder(testCaseFolderId, testCaseFolderPatch.getName());
    }

    @PostMapping(value={"/{testCaseFolderId}/description"})
    public void changeDescription(@PathVariable long testCaseFolderId, @RequestBody TestCaseFolderPatch testCaseFolderPatch) {
        this.folderModificationService.updateFolderDescription(testCaseFolderId, testCaseFolderPatch.getDescription());
    }

    static class TestCaseFolderPatch {
        private String name;
        private String description;

        TestCaseFolderPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

