/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.testcase;

import com.google.common.collect.Lists;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.testcase.TestCaseDisplayService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TestCaseFolderDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.testcase.TestCaseLibraryNavigationService;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/test-case-folder-view"})
public class TestCaseFolderViewController {
    private TestCaseDisplayService testCaseDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;
    private final TestCaseLibraryNavigationService testCaseLibraryNavigationService;

    public TestCaseFolderViewController(TestCaseDisplayService testCaseDisplayService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider, TestCaseLibraryNavigationService testCaseLibraryNavigationService) {
        this.testCaseDisplayService = testCaseDisplayService;
        this.builderProvider = builderProvider;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.testCaseLibraryNavigationService = testCaseLibraryNavigationService;
    }

    @GetMapping(value={"/{testCaseFolderId}"})
    public TestCaseFolderDto getTestCaseView(@PathVariable long testCaseFolderId, Locale locale) {
        TestCaseFolderDto dto = this.testCaseDisplayService.getTestCaseFolderView(testCaseFolderId);
        if (dto.isShouldShowFavoriteDashboard()) {
            if (dto.isCanShowFavoriteDashboard()) {
                EntityReference library = new EntityReference(EntityType.TEST_CASE_FOLDER, Long.valueOf(testCaseFolderId));
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(dto.getFavoriteDashboardId());
                CustomReportDashboardDto dashboardScopeDto = new CustomReportDashboardDto(Workspace.TEST_CASE, Collections.singletonList(library));
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(dto.getFavoriteDashboardId(), dashboard, locale, dashboardScopeDto);
                dto.setDashboard(jsonDashboard);
            }
        } else {
            dto.setStatistics(this.testCaseLibraryNavigationService.getStatisticsForSelection(Collections.emptyList(), (Collection)Lists.newArrayList((Object[])new Long[]{testCaseFolderId})));
        }
        return dto;
    }
}

