/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.server;

import jakarta.inject.Inject;
import jakarta.validation.Valid;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.testautomation.TestAutomationServer;
import org.squashtest.tm.service.display.test.automation.server.TestAutomationServerDisplayService;
import org.squashtest.tm.service.internal.display.dto.TestAutomationServerDto;
import org.squashtest.tm.service.internal.display.grid.GridRequest;
import org.squashtest.tm.service.internal.display.grid.GridResponse;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.service.testautomation.environment.AutomatedExecutionEnvironmentService;
import org.squashtest.tm.service.thirdpartyserver.ThirdPartyServerCredentialsService;
import org.squashtest.tm.web.backend.controller.form.model.TestAutomationServerFormModel;
import org.squashtest.tm.web.backend.controller.utils.UrlValidator;

@RestController
@RequestMapping(value={"/backend/test-automation-servers"})
public class TestAutomationServersController {
    private static final String TEST_AUTOMATION_SERVER_URL = "/{serverIds}";
    private final TestAutomationServerDisplayService testAutomationServerDisplayService;
    private final TestAutomationServerManagerService testAutomationServerManagerService;
    private final ThirdPartyServerCredentialsService credentialsService;
    private final AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService;

    @Inject
    public TestAutomationServersController(TestAutomationServerDisplayService testAutomationServerDisplayService, TestAutomationServerManagerService testAutomationServerManagerService, ThirdPartyServerCredentialsService credentialsService, AutomatedExecutionEnvironmentService automatedExecutionEnvironmentService) {
        this.testAutomationServerDisplayService = testAutomationServerDisplayService;
        this.testAutomationServerManagerService = testAutomationServerManagerService;
        this.credentialsService = credentialsService;
        this.automatedExecutionEnvironmentService = automatedExecutionEnvironmentService;
    }

    @GetMapping
    public Map<String, List<TestAutomationServerDto>> getAll() {
        return Collections.singletonMap("testAutomationServers", this.testAutomationServerDisplayService.findAll());
    }

    @PostMapping
    public GridResponse getAllAutomationServers(@RequestBody GridRequest request) {
        return this.testAutomationServerDisplayService.getTestAutomationServerGrid(request);
    }

    @DeleteMapping(value={"/{serverIds}"})
    public void deleteAutomationServers(@PathVariable(value="serverIds") List<Long> serverIds) {
        this.testAutomationServerManagerService.deleteServers(serverIds);
    }

    @PostMapping(value={"/new"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Map<String, Object> createNewAutomationServer(@RequestBody TestAutomationServerFormModel formModel) {
        UrlValidator.checkURL(formModel.getBaseUrl());
        TestAutomationServer server = formModel.getTestAutomationServer();
        this.testAutomationServerManagerService.persist(server);
        return Collections.singletonMap("id", server.getId());
    }

    @PostMapping(value={"/{testAutomationServerId}/name"})
    public void changeName(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        this.testAutomationServerManagerService.changeName(testAutomationServerId, patch.getName());
    }

    @PostMapping(value={"/{testAutomationServerId}/base-url"})
    public void changeURL(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        URL url = UrlValidator.checkURL(patch.getBaseUrl());
        this.testAutomationServerManagerService.changeURL(testAutomationServerId, url);
    }

    @PostMapping(value={"/{testAutomationServerId}/description"})
    public void changeDescription(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        this.testAutomationServerManagerService.changeDescription(testAutomationServerId, patch.getDescription());
    }

    @PostMapping(value={"/{testAutomationServerId}/manual-selection"})
    public void changeManualSelection(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        this.testAutomationServerManagerService.changeManualSlaveSelection(testAutomationServerId, patch.isManualSlaveSelection());
    }

    @PostMapping(value={"/{testAutomationServerId}/authentication-protocol"})
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void changeAuthProtocol(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        AuthenticationProtocol protocol = Enum.valueOf(AuthenticationProtocol.class, patch.getProtocol());
        this.credentialsService.changeAuthenticationProtocol(testAutomationServerId, protocol);
    }

    @PostMapping(value={"/{testAutomationServerId}/authentication-protocol/configuration"})
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void saveAuthConfiguration(@PathVariable long testAutomationServerId, @Valid @RequestBody ServerAuthConfiguration configuration) {
        this.credentialsService.storeAuthConfiguration(testAutomationServerId, configuration);
    }

    @PostMapping(value={"/{testAutomationServerId}/credentials"})
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void storeCredentials(@PathVariable long testAutomationServerId, @RequestBody ManageableCredentials credentials) {
        this.credentialsService.storeCredentials(testAutomationServerId, credentials);
        this.testAutomationServerManagerService.forceAuditAfterCredentialsUpdated(testAutomationServerId);
        if (this.automatedExecutionEnvironmentService.doesServerSupportAutomatedExecutionEnvironments(testAutomationServerId)) {
            this.testAutomationServerManagerService.clearEnvironmentTags(testAutomationServerId);
        }
    }

    @DeleteMapping(value={"/{testAutomationServerId}/credentials"})
    @PreAuthorize(value="(@environment.getProperty('squash.cloud-mode-enabled') == 'true') ? hasRole('ROLE_INFRASTRUCTURE_ADMIN') : hasRole('ROLE_ADMIN')")
    public void deleteCredentials(@PathVariable long testAutomationServerId) {
        this.credentialsService.deleteCredentials(testAutomationServerId);
        this.testAutomationServerManagerService.forceAuditAfterCredentialsUpdated(testAutomationServerId);
    }

    @PostMapping(value={"/{testAutomationServerId}/observer-url"})
    public void changeObserverURL(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        String observerUrl = patch.getObserverUrl();
        if (StringUtils.isBlank((CharSequence)observerUrl)) {
            this.testAutomationServerManagerService.clearObserverURL(testAutomationServerId);
        } else {
            URL url = UrlValidator.checkURL(observerUrl);
            this.testAutomationServerManagerService.changeObserverURL(testAutomationServerId, url);
        }
    }

    @PostMapping(value={"/{testAutomationServerId}/event-bus-url"})
    public void changeEventBusURL(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        String eventBusUrl = patch.getEventBusUrl();
        if (StringUtils.isBlank((CharSequence)eventBusUrl)) {
            this.testAutomationServerManagerService.clearEventBusURL(testAutomationServerId);
        } else {
            URL url = UrlValidator.checkURL(eventBusUrl);
            this.testAutomationServerManagerService.changeEventBusURL(testAutomationServerId, url);
        }
    }

    @PostMapping(value={"/{testAutomationServerId}/additional-configuration"})
    public void changeAdditionalConfiguration(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        String additionalConfiguration = patch.getAdditionalConfiguration();
        if (StringUtils.isBlank((CharSequence)additionalConfiguration)) {
            this.testAutomationServerManagerService.changeAdditionalConfiguration(testAutomationServerId, null);
        } else {
            this.testAutomationServerManagerService.changeAdditionalConfiguration(testAutomationServerId, additionalConfiguration);
        }
    }

    @PostMapping(value={"/{testAutomationServerId}/check-additional-configuration"})
    public boolean checkAdditionalConfigurationSyntax(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        String additionalConfiguration = patch.getAdditionalConfiguration();
        return this.testAutomationServerManagerService.isAdditionalConfigurationValid(additionalConfiguration);
    }

    @PostMapping(value={"/{testAutomationServerId}/kill-switch-url"})
    public void changeKillSwitchURL(@PathVariable long testAutomationServerId, @RequestBody TestAutomationServerPatch patch) {
        String killSwitchUrl = patch.getKillSwitchUrl();
        if (StringUtils.isBlank((CharSequence)killSwitchUrl)) {
            this.testAutomationServerManagerService.clearKillSwitchURL(testAutomationServerId);
        } else {
            URL url = UrlValidator.checkURL(killSwitchUrl);
            this.testAutomationServerManagerService.changeKillSwitchURL(testAutomationServerId, url);
        }
    }

    public static class TestAutomationServerPatch {
        String name;
        String baseUrl;
        String description;
        boolean manualSlaveSelection;
        String protocol;
        String observerUrl;
        String eventBusUrl;
        String additionalConfiguration;
        String killSwitchUrl;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean isManualSlaveSelection() {
            return this.manualSlaveSelection;
        }

        public void setManualSlaveSelection(boolean manualSlaveSelection) {
            this.manualSlaveSelection = manualSlaveSelection;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getObserverUrl() {
            return this.observerUrl;
        }

        public void setObserverUrl(String observerUrl) {
            this.observerUrl = observerUrl;
        }

        public String getEventBusUrl() {
            return this.eventBusUrl;
        }

        public void setEventBusUrl(String eventBusUrl) {
            this.eventBusUrl = eventBusUrl;
        }

        public String getAdditionalConfiguration() {
            return this.additionalConfiguration;
        }

        public void setAdditionalConfiguration(String additionalConfiguration) {
            this.additionalConfiguration = additionalConfiguration;
        }

        public String getKillSwitchUrl() {
            return this.killSwitchUrl;
        }

        public void setKillSwitchUrl(String killSwitchUrl) {
            this.killSwitchUrl = killSwitchUrl;
        }
    }
}

