/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.test.automation.project;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.core.foundation.logger.Logger;
import org.squashtest.tm.core.foundation.logger.LoggerFactory;
import org.squashtest.tm.domain.testautomation.TestAutomationProject;
import org.squashtest.tm.exception.DomainException;
import org.squashtest.tm.exception.RequiredFieldException;
import org.squashtest.tm.service.internal.display.dto.TestAutomationProjectDto;
import org.squashtest.tm.service.testautomation.TestAutomationProjectManagerService;
import org.squashtest.tm.web.backend.model.testautomation.TAUsageStatus;

@RestController
@RequestMapping(value={"/backend/test-automation-projects"})
public class TestAutomationProjectController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestAutomationProjectController.class);
    private static final String PROJECT_ID = "/{projectId}";
    private static final String PROJECT_IDS = "/{projectIds}";
    private static final String TA_PROJECT = "ta-project";
    private static final String TA_PROJECTS = "taProjects";
    @Inject
    private TestAutomationProjectManagerService service;

    @DeleteMapping(value={"/{projectId}"})
    public void deleteTestAutomationProject(@PathVariable long projectId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Delete test automation project of id #{}", new Object[]{projectId});
        }
        this.service.deleteProject(projectId);
    }

    @PostMapping(value={"/{projectId}"})
    public Map<String, List<TestAutomationProjectDto>> editTestAutomationProject(@PathVariable long projectId, @RequestBody Patch patch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Edit test automation project of id #{}", new Object[]{projectId});
        }
        try {
            TestAutomationProject testAutomationProject = new TestAutomationProject();
            testAutomationProject.setCanRunGherkin(patch.isCanRunBdd());
            testAutomationProject.setJobName(patch.getRemoteName());
            testAutomationProject.setLabel(patch.getLabel());
            testAutomationProject.setSlaves(patch.getExecutionEnvironment());
            this.service.editProject(projectId, testAutomationProject);
            Long tmProjectId = this.service.findProjectById(projectId).getTmProject().getId();
            return Collections.singletonMap(TA_PROJECTS, this.service.findAllByTMProject(tmProjectId.longValue()));
        }
        catch (DomainException de) {
            de.setObjectName(TA_PROJECT);
            throw de;
        }
    }

    @GetMapping(value={"/{projectIds}/usage-status"})
    public Map<String, TAUsageStatus> getTestAutomationUsageStatus(@PathVariable List<Long> projectIds) {
        boolean hasExecutedTests = projectIds.stream().anyMatch(id -> this.service.haveExecutedTests(Collections.singletonList(id)));
        return Collections.singletonMap("usageStatus", new TAUsageStatus(hasExecutedTests));
    }

    @PostMapping(value={"/{projectId}/label"})
    public Map<String, List<TestAutomationProjectDto>> changeLabel(@PathVariable long projectId, @RequestBody Patch patch) {
        if (patch.getLabel() == null || patch.getLabel().trim().isEmpty()) {
            throw new RequiredFieldException("label");
        }
        try {
            this.service.changeLabel(projectId, patch.getLabel().trim());
            Long tmProjectId = this.service.findProjectById(projectId).getTmProject().getId();
            return Collections.singletonMap(TA_PROJECTS, this.service.findAllByTMProject(tmProjectId.longValue()));
        }
        catch (DomainException de) {
            de.setObjectName(TA_PROJECT);
            throw de;
        }
    }

    @PostMapping(value={"/{projectId}/can-run-bdd"})
    public Map<String, List<TestAutomationProjectDto>> changeCanRunBdd(@PathVariable long projectId, @RequestBody Patch patch) {
        try {
            this.service.changeCanRunGherkin(projectId, patch.isCanRunBdd());
            Long tmProjectId = this.service.findProjectById(projectId).getTmProject().getId();
            return Collections.singletonMap(TA_PROJECTS, this.service.findAllByTMProject(tmProjectId.longValue()));
        }
        catch (DomainException de) {
            de.setObjectName(TA_PROJECT);
            throw de;
        }
    }

    static class Patch {
        String label;
        boolean canRunBdd;
        Long taProjectId;
        String remoteName;
        String executionEnvironment;

        Patch() {
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isCanRunBdd() {
            return this.canRunBdd;
        }

        public void setCanRunBdd(boolean canRunBdd) {
            this.canRunBdd = canRunBdd;
        }

        public Long getTaProjectId() {
            return this.taProjectId;
        }

        public void setTaProjectId(Long taProjectId) {
            this.taProjectId = taProjectId;
        }

        public String getExecutionEnvironment() {
            return this.executionEnvironment;
        }

        public void setExecutionEnvironment(String executionEnvironment) {
            this.executionEnvironment = executionEnvironment;
        }

        public String getRemoteName() {
            return this.remoteName;
        }

        public void setRemoteName(String remoteName) {
            this.remoteName = remoteName;
        }
    }
}

