/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.team;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.display.team.TeamDisplayService;
import org.squashtest.tm.service.internal.display.dto.TeamAdminViewDto;
import org.squashtest.tm.service.internal.display.dto.testcase.TeamMemberDto;
import org.squashtest.tm.service.project.ProjectsPermissionManagementService;
import org.squashtest.tm.service.user.TeamModificationService;
import org.squashtest.tm.web.backend.controller.project.ProjectModel;

@RestController
@RequestMapping(value={"/backend/team-view"})
public class TeamViewController {
    private final TeamDisplayService teamDisplayService;
    private final ProjectsPermissionManagementService permissionService;
    private final TeamModificationService teamModificationService;

    @Inject
    TeamViewController(TeamDisplayService teamDisplayService, ProjectsPermissionManagementService permissionService, TeamModificationService teamModificationService) {
        this.teamDisplayService = teamDisplayService;
        this.permissionService = permissionService;
        this.teamModificationService = teamModificationService;
    }

    @GetMapping(value={"/{teamId}"})
    public TeamAdminViewDto getTeamView(@PathVariable long teamId) {
        return this.teamDisplayService.getTeamView(teamId);
    }

    @GetMapping(value={"/{teamId}/projects-without-permission"})
    public List<ProjectModel> getProjectWithoutPermission(@PathVariable long teamId) {
        List projectList = this.permissionService.findProjectWithoutPermissionByParty(teamId, Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}));
        ArrayList<ProjectModel> projectModelList = new ArrayList<ProjectModel>();
        if (projectList != null) {
            for (GenericProject project : projectList) {
                projectModelList.add(new ProjectModel(project));
            }
        }
        return projectModelList;
    }

    @GetMapping(value={"/{teamId}/non-members"}, headers={"Accept=application/json"})
    public List<TeamMemberDto> getNonMembers(@PathVariable long teamId) {
        List<User> nonMembers = this.teamModificationService.findAllNonMemberUsers(teamId);
        nonMembers = nonMembers.stream().filter(user -> !user.isFromInfrastructureAdminGroup()).toList();
        ArrayList<TeamMemberDto> nonMembersListDto = new ArrayList<TeamMemberDto>();
        nonMembers.forEach(member -> {
            TeamMemberDto memberDto = new TeamMemberDto();
            memberDto.setPartyId(member.getId());
            memberDto.setActive(member.getActive());
            memberDto.setFirstName(member.getFirstName());
            memberDto.setLastName(member.getLastName());
            memberDto.setLogin(member.getLogin());
            nonMembersListDto.add(memberDto);
        });
        return nonMembersListDto;
    }

    @GetMapping(value={"/{teamId}/has-custom-profile"})
    public boolean hasCustomProfile(@PathVariable long teamId) {
        return this.teamDisplayService.hasCustomProfile(teamId);
    }
}

