/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseModificationService;

@RestController
@RequestMapping(value={"backend/search/milestones"})
public class SearchMilestoneModificationController {
    private final TestCaseModificationService testCaseModificationService;
    private final RequirementVersionManagerService requirementVersionManagerService;

    public SearchMilestoneModificationController(TestCaseModificationService testCaseModificationService, RequirementVersionManagerService requirementVersionManagerService) {
        this.testCaseModificationService = testCaseModificationService;
        this.requirementVersionManagerService = requirementVersionManagerService;
    }

    @GetMapping(value={"test-case/{testCaseIds}"})
    public MilestoneMassEdit getMilestoneMassEditForTc(@PathVariable List<Long> testCaseIds) {
        Collection checkedIds = this.testCaseModificationService.findBindedMilestonesIdForMassModif(testCaseIds);
        Collection milestones = this.testCaseModificationService.findAssociableMilestonesForMassModif(testCaseIds);
        Collection milestoneIds = milestones.stream().map(Milestone::getId).collect(Collectors.toCollection(ArrayList::new));
        boolean samePerimeter = this.testCaseModificationService.haveSamePerimeter(testCaseIds);
        return new MilestoneMassEdit(checkedIds, milestoneIds, samePerimeter);
    }

    @PostMapping(value={"test-case"})
    public void bindMilestonesToTcs(@RequestBody MilestonesPatch milestonesPatch) {
        Collection bindedBefore = this.testCaseModificationService.findBindedMilestonesIdForMassModif(milestonesPatch.bindableObjectIds());
        bindedBefore.removeAll(milestonesPatch.milestoneIds());
        for (Long testCaseId : milestonesPatch.bindableObjectIds()) {
            this.testCaseModificationService.bindMilestones(testCaseId.longValue(), milestonesPatch.milestoneIds());
            this.testCaseModificationService.unbindMilestones(testCaseId.longValue(), bindedBefore);
        }
    }

    @GetMapping(value={"requirement/{requirementVersionIds}"})
    public MilestoneMassEdit getMilestoneMassEditForRequirement(@PathVariable List<Long> requirementVersionIds) {
        Collection checkedIds = this.requirementVersionManagerService.findBindedMilestonesIdForMassModif(requirementVersionIds);
        Collection milestones = this.requirementVersionManagerService.findAssociableMilestonesForMassModif(requirementVersionIds);
        Collection milestoneIds = milestones.stream().map(Milestone::getId).collect(Collectors.toCollection(ArrayList::new));
        boolean samePerimeter = this.requirementVersionManagerService.haveSamePerimeter(requirementVersionIds);
        return new MilestoneMassEdit(checkedIds, milestoneIds, samePerimeter);
    }

    @PostMapping(value={"requirement"})
    public boolean bindMilestonesToReqVersions(@RequestBody MilestonesPatch milestonesPatch) {
        List<Long> reqVersionIds = milestonesPatch.bindableObjectIds();
        List<Long> milestoneIds = milestonesPatch.milestoneIds();
        Collection bindedBefore = this.requirementVersionManagerService.findBindedMilestonesIdForMassModif(reqVersionIds);
        bindedBefore.removeAll(milestoneIds);
        boolean isOneVersionAlreadyBound = !milestoneIds.isEmpty() && this.requirementVersionManagerService.isOneMilestoneAlreadyBindToAnotherRequirementVersion(reqVersionIds, milestoneIds);
        for (Long reqVersionId : reqVersionIds) {
            this.requirementVersionManagerService.bindMilestones(reqVersionId.longValue(), milestoneIds);
            this.requirementVersionManagerService.unbindMilestones(reqVersionId.longValue(), bindedBefore);
        }
        return isOneVersionAlreadyBound;
    }

    private record MilestoneMassEdit(Collection<Long> checkedIds, Collection<Long> milestoneIds, boolean samePerimeter) {
    }

    private record MilestonesPatch(List<Long> milestoneIds, List<Long> bindableObjectIds) {
    }
}

