/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import jakarta.inject.Named;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.requirement.RequirementFolder;
import org.squashtest.tm.service.library.FolderModificationService;

@RestController
@RequestMapping(value={"/backend/requirement-folder"})
public class RequirementFolderViewModificationController {
    private FolderModificationService<RequirementFolder> folderModificationService;

    public RequirementFolderViewModificationController(@Named(value="squashtest.tm.service.RequirementFolderModificationService") FolderModificationService<RequirementFolder> folderModificationService) {
        this.folderModificationService = folderModificationService;
    }

    @PostMapping(value={"/{requirementFolderId}/name"})
    public void changeName(@PathVariable long requirementFolderId, @RequestBody RequirementFolderPatch requirementFolderPatch) {
        this.folderModificationService.renameFolder(requirementFolderId, requirementFolderPatch.getName());
    }

    @PostMapping(value={"/{requirementFolderId}/description"})
    public void changeDescription(@PathVariable long requirementFolderId, @RequestBody RequirementFolderPatch requirementFolderPatch) {
        this.folderModificationService.updateFolderDescription(requirementFolderId, requirementFolderPatch.getDescription());
    }

    static class RequirementFolderPatch {
        private String name;
        private String description;

        RequirementFolderPatch() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

