/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.Locale;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.internal.display.dto.customreports.CustomReportDashboardDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementFolderDto;
import org.squashtest.tm.service.internal.dto.json.JsonCustomReportDashboard;
import org.squashtest.tm.service.requirement.RequirementLibraryNavigationService;
import org.squashtest.tm.web.backend.model.builder.JsonCustomReportDashboardBuilder;

@RestController
@RequestMapping(value={"/backend/requirement-folder-view"})
public class RequirementFolderViewController {
    private final RequirementLibraryNavigationService requirementLibraryNavigationService;
    private final RequirementDisplayService requirementDisplayService;
    private final CustomReportLibraryNodeService customReportLibraryNodeService;
    @Named(value="customReport.dashboardBuilder")
    private final Provider<JsonCustomReportDashboardBuilder> builderProvider;

    public RequirementFolderViewController(RequirementDisplayService requirementDisplayService, RequirementLibraryNavigationService requirementLibraryNavigationService, CustomReportLibraryNodeService customReportLibraryNodeService, Provider<JsonCustomReportDashboardBuilder> builderProvider) {
        this.requirementDisplayService = requirementDisplayService;
        this.requirementLibraryNavigationService = requirementLibraryNavigationService;
        this.customReportLibraryNodeService = customReportLibraryNodeService;
        this.builderProvider = builderProvider;
    }

    @GetMapping(value={"/{requirementFolderId}"})
    public RequirementFolderDto getRequirementFolderView(@PathVariable long requirementFolderId, Locale locale, @RequestParam boolean extendHighLvlReqScope) {
        RequirementFolderDto requirementFolderView = this.requirementDisplayService.getRequirementFolderView(requirementFolderId);
        if (requirementFolderView.isShouldShowFavoriteDashboard()) {
            if (requirementFolderView.isCanShowFavoriteDashboard()) {
                EntityReference folder = new EntityReference(EntityType.REQUIREMENT_FOLDER, Long.valueOf(requirementFolderId));
                CustomReportDashboard dashboard = this.customReportLibraryNodeService.findCustomReportDashboardById(requirementFolderView.getFavoriteDashboardId());
                CustomReportDashboardDto dashboardDto = new CustomReportDashboardDto(Workspace.REQUIREMENT, Collections.singletonList(folder), false, extendHighLvlReqScope, false);
                JsonCustomReportDashboard jsonDashboard = ((JsonCustomReportDashboardBuilder)this.builderProvider.get()).build(requirementFolderView.getFavoriteDashboardId(), dashboard, locale, dashboardDto);
                requirementFolderView.setDashboard(jsonDashboard);
            }
        } else {
            requirementFolderView.setStatistics(this.requirementLibraryNavigationService.getStatisticsForSelection(Collections.emptyList(), Collections.singleton(requirementFolderId), extendHighLvlReqScope));
        }
        return requirementFolderView;
    }
}

