/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.backend.controller.requirement;

import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.service.display.requirements.RequirementDisplayService;
import org.squashtest.tm.service.display.requirements.RequirementPathFinderService;
import org.squashtest.tm.service.internal.display.dto.requirement.HighLevelRequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionBundleStatsDto;
import org.squashtest.tm.service.internal.display.dto.requirement.RequirementVersionDto;
import org.squashtest.tm.service.internal.display.dto.requirement.VerifyingTestCaseDto;
import org.squashtest.tm.service.internal.dto.HighLevelRequirementExceptionSummary;
import org.squashtest.tm.service.requirement.HighLevelRequirementService;
import org.squashtest.tm.service.requirement.RequirementHelper;
import org.squashtest.tm.service.requirement.RequirementStatisticsService;

@RestController
@RequestMapping(value={"backend/high-level-requirement"})
public class HighLevelRequirementController {
    private final HighLevelRequirementService highLevelRequirementService;
    private final RequirementDisplayService requirementDisplayService;
    private final RequirementStatisticsService requirementStatisticsService;
    private final RequirementHelper requirementHelper;
    private final RequirementPathFinderService requirementsPathService;

    public HighLevelRequirementController(HighLevelRequirementService highLevelRequirementService, RequirementDisplayService requirementDisplayService, RequirementStatisticsService requirementStatisticsService, RequirementHelper requirementHelper, RequirementPathFinderService requirementsPathService) {
        this.highLevelRequirementService = highLevelRequirementService;
        this.requirementDisplayService = requirementDisplayService;
        this.requirementStatisticsService = requirementStatisticsService;
        this.requirementHelper = requirementHelper;
        this.requirementsPathService = requirementsPathService;
    }

    @PostMapping(value={"/{lowLevelRequirementId}/link/{highLevelRequirementId}"})
    public RequirementVersionDto.LinkedHighLevelRequirementDto linkToHighLevelRequirement(@PathVariable Long lowLevelRequirementId, @PathVariable Long highLevelRequirementId) {
        if (this.requirementHelper.checkIfRequirementIsNotChild(lowLevelRequirementId)) {
            this.highLevelRequirementService.linkToHighLevelRequirement(highLevelRequirementId, lowLevelRequirementId);
            RequirementVersionDto.LinkedHighLevelRequirementDto linkedHighLevelRequirementDto = this.requirementDisplayService.findLinkedHighLevelRequirement(lowLevelRequirementId);
            String path = this.requirementsPathService.buildRequirementLinkPath(linkedHighLevelRequirementDto.getRequirementId(), linkedHighLevelRequirementDto.getProjectName());
            linkedHighLevelRequirementDto.setPath(path);
            return linkedHighLevelRequirementDto;
        }
        return new RequirementVersionDto.LinkedHighLevelRequirementDto();
    }

    @DeleteMapping(value={"/{lowLevelRequirementId}/unlink"})
    public void unlinkToHighLevelRequirement(@PathVariable Long lowLevelRequirementId) {
        if (this.requirementHelper.checkIfRequirementIsNotChild(lowLevelRequirementId)) {
            this.highLevelRequirementService.unlinkToHighLevelRequirement(lowLevelRequirementId);
        }
    }

    @PostMapping(value={"/{highLevelRequirementId}/bind-requirement-to-high-level-requirement/{lowLevelRequirementIds}"})
    public BindRequirementToHighLevelRequirementOperationReport bindRequirementToHighLevelRequirement(@PathVariable Long highLevelRequirementId, @PathVariable List<Long> lowLevelRequirementIds) {
        HighLevelRequirementExceptionSummary summary = new HighLevelRequirementExceptionSummary();
        this.highLevelRequirementService.bindRequirementsToHighLevelRequirement(highLevelRequirementId, lowLevelRequirementIds, summary);
        BindRequirementToHighLevelRequirementOperationReport report = new BindRequirementToHighLevelRequirementOperationReport(this.highLevelRequirementService.findLinkedLowLevelRequirements(highLevelRequirementId), this.requirementDisplayService.findVerifyingTestCasesByHighLvlReqIdForCurrentVersion(highLevelRequirementId), this.requirementStatisticsService.findCoveragesStatsByHighLvlReqId(highLevelRequirementId), this.requirementDisplayService.countIssuesByHighLvlReqId(highLevelRequirementId));
        report.setSummary(summary);
        return report;
    }

    @DeleteMapping(value={"/{highLevelRequirementId}/unbind-requirement-from-high-level-requirement/{lowLevelRequirementIds}"})
    public BindRequirementToHighLevelRequirementOperationReport unbindRequirementFromHighLevelRequirement(@PathVariable Long highLevelRequirementId, @PathVariable List<Long> lowLevelRequirementIds) {
        this.highLevelRequirementService.unbindRequirementFromHighLevelRequirement(highLevelRequirementId, lowLevelRequirementIds);
        return new BindRequirementToHighLevelRequirementOperationReport(this.highLevelRequirementService.findLinkedLowLevelRequirements(highLevelRequirementId), this.requirementDisplayService.findVerifyingTestCasesByHighLvlReqIdForCurrentVersion(highLevelRequirementId), this.requirementStatisticsService.findCoveragesStatsByHighLvlReqId(highLevelRequirementId), this.requirementDisplayService.countIssuesByHighLvlReqId(highLevelRequirementId));
    }

    @PostMapping(value={"/convert-into-high-level-requirement/{requirementId}"})
    public void convertIntoHighLevelRequirement(@PathVariable long requirementId) {
        this.highLevelRequirementService.convertIntoHighLevelRequirement(requirementId);
    }

    @PostMapping(value={"/convert-into-standard-requirement/{requirementId}"})
    public void convertIntoStandardRequirement(@PathVariable long requirementId) {
        this.highLevelRequirementService.convertIntoStandardRequirement(requirementId);
    }

    static class BindRequirementToHighLevelRequirementOperationReport {
        private List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> linkedLowLevelRequirements;
        private List<VerifyingTestCaseDto> verifyingTestCases;
        private RequirementVersionBundleStatsDto requirementStats;
        private Integer nbIssues;
        private HighLevelRequirementExceptionSummary summary;

        public BindRequirementToHighLevelRequirementOperationReport(List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> linkedLowLevelRequirements, List<VerifyingTestCaseDto> verifyingTestCases, RequirementVersionBundleStatsDto requirementStats, Integer nbIssues) {
            this.linkedLowLevelRequirements = linkedLowLevelRequirements;
            this.verifyingTestCases = verifyingTestCases;
            this.requirementStats = requirementStats;
            this.nbIssues = nbIssues;
        }

        public List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> getLinkedLowLevelRequirements() {
            return this.linkedLowLevelRequirements;
        }

        public void setLinkedLowLevelRequirements(List<HighLevelRequirementVersionDto.LinkedLowLevelRequirementDto> linkedLowLevelRequirements) {
            this.linkedLowLevelRequirements = linkedLowLevelRequirements;
        }

        public RequirementVersionBundleStatsDto getRequirementStats() {
            return this.requirementStats;
        }

        public void setRequirementStats(RequirementVersionBundleStatsDto requirementStats) {
            this.requirementStats = requirementStats;
        }

        public List<VerifyingTestCaseDto> getVerifyingTestCases() {
            return this.verifyingTestCases;
        }

        public void setVerifyingTestCases(List<VerifyingTestCaseDto> verifyingTestCases) {
            this.verifyingTestCases = verifyingTestCases;
        }

        public Integer getNbIssues() {
            return this.nbIssues;
        }

        public void setNbIssues(Integer nbIssues) {
            this.nbIssues = nbIssues;
        }

        public HighLevelRequirementExceptionSummary getSummary() {
            return this.summary;
        }

        public void setSummary(HighLevelRequirementExceptionSummary summary) {
            this.summary = summary;
        }
    }
}

